/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.neo4j.repository.query.derived.builder.BetweenComparisonBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.BooleanComparisonBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.DistanceComparisonBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.ExistsFilterBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.FilterBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.IsNullFilterBuilder;
import org.springframework.data.neo4j.repository.query.derived.builder.PropertyComparisonBuilder;
import org.springframework.data.repository.query.parser.Part;

public class CypherFinderQuery
implements DerivedQueryDefinition {
    private Class<?> entityType;
    private Part basePart;
    private List<FilterBuilder> filterBuilders = new ArrayList<FilterBuilder>();

    CypherFinderQuery(Class<?> entityType, Part basePart) {
        this.entityType = entityType;
        this.basePart = basePart;
    }

    @Override
    public Part getBasePart() {
        return this.basePart;
    }

    @Override
    public List<Filter> getFilters(Map<Integer, Object> params) {
        Stack<Object> parametersStack = new Stack<Object>();
        if (!params.isEmpty()) {
            Integer maxParameterIndex = Collections.max(params.keySet());
            for (int i = 0; i <= maxParameterIndex; ++i) {
                parametersStack.add(0, params.get(i));
            }
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (FilterBuilder filterBuilder : this.filterBuilders) {
            filters.addAll(filterBuilder.build(parametersStack));
        }
        return filters;
    }

    @Override
    public void addPart(Part part, BooleanOperator booleanOperator) {
        FilterBuilder builder = this.builderForPart(part, booleanOperator);
        this.filterBuilders.add(builder);
    }

    private FilterBuilder builderForPart(Part part, BooleanOperator booleanOperator) {
        switch (part.getType()) {
            case NEAR: {
                return new DistanceComparisonBuilder(part, booleanOperator, this.entityType);
            }
            case BETWEEN: {
                return new BetweenComparisonBuilder(part, booleanOperator, this.entityType);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return new IsNullFilterBuilder(part, booleanOperator, this.entityType);
            }
            case EXISTS: {
                return new ExistsFilterBuilder(part, booleanOperator, this.entityType);
            }
            case TRUE: 
            case FALSE: {
                return new BooleanComparisonBuilder(part, booleanOperator, this.entityType);
            }
        }
        return new PropertyComparisonBuilder(part, booleanOperator, this.entityType);
    }
}

