/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class GraphEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private final MetaData metaData;

    public GraphEntityInformation(MetaData metaData, Class<T> type) {
        super(type);
        this.metaData = metaData;
    }

    public ID getId(T entity) {
        ClassInfo classInfo = this.metaData.classInfo(this.getJavaType().getName());
        FieldInfo primaryIndex = classInfo.primaryIndexField();
        if (primaryIndex != null) {
            return (ID)((Serializable)EntityAccessManager.getPropertyReader((ClassInfo)classInfo, (String)primaryIndex.getName()).readProperty(entity));
        }
        return (ID)((Serializable)EntityAccessManager.getPropertyReader((ClassInfo)classInfo, (String)classInfo.identityField().getName()).readProperty(entity));
    }

    public Class<ID> getIdType() {
        FieldInfo primaryIndex = this.metaData.classInfo(this.getJavaType().getName()).primaryIndexField();
        if (primaryIndex != null) {
            return primaryIndex.convertedType();
        }
        return Long.class;
    }
}

