/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.Iterator;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryBuilder;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class DerivedQueryCreator
extends AbstractQueryCreator<DerivedQueryDefinition, DerivedQueryBuilder> {
    private final Class<?> entityType;

    public DerivedQueryCreator(PartTree tree, Class<?> entityType) {
        super(tree);
        this.entityType = entityType;
    }

    protected DerivedQueryBuilder create(Part part, Iterator<Object> iterator) {
        DerivedQueryBuilder queryBuilder = new DerivedQueryBuilder(this.entityType, part);
        queryBuilder.addPart(part, BooleanOperator.NONE);
        return queryBuilder;
    }

    protected DerivedQueryBuilder and(Part part, DerivedQueryBuilder base, Iterator<Object> iterator) {
        base.addPart(part, BooleanOperator.AND);
        return base;
    }

    protected DerivedQueryBuilder or(DerivedQueryBuilder base, DerivedQueryBuilder criteria) {
        base.addPart(criteria, BooleanOperator.OR);
        return base;
    }

    protected DerivedQueryDefinition complete(DerivedQueryBuilder builder, Sort sort) {
        return builder.buildQuery();
    }
}

