/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;

public class SessionBeanDefinitionRegistrarPostProcessor
implements BeanFactoryPostProcessor,
PersistenceExceptionTranslator {
    private static String getSessionFactoryBeanRef(ConfigurableListableBeanFactory beanFactory) {
        return beanFactory.containsBeanDefinition("sessionFactory") ? "sessionFactory" : "getSessionFactory";
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SessionFactoryBeanDefinition sfbd = new SessionFactoryBeanDefinition(BeanFactoryUtils.transformedBeanName((String)SessionBeanDefinitionRegistrarPostProcessor.getSessionFactoryBeanRef(beanFactory)), beanFactory);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.data.neo4j.transaction.SharedSessionCreator");
        builder.setFactoryMethod("createSharedSession");
        builder.addConstructorArgReference(sfbd.getBeanName());
        AbstractBeanDefinition emBeanDefinition = builder.getRawBeanDefinition();
        emBeanDefinition.setScope(sfbd.getBeanDefinition().getScope());
        emBeanDefinition.setSource(sfbd.getBeanDefinition().getSource());
        emBeanDefinition.setAutowireCandidate(true);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)emBeanDefinition, (BeanDefinitionRegistry)((BeanDefinitionRegistry)sfbd.getBeanFactory()));
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return SessionFactoryUtils.convertOgmAccessException(ex);
    }

    private static class SessionFactoryBeanDefinition {
        private final String beanName;
        private final ConfigurableListableBeanFactory beanFactory;

        SessionFactoryBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            this.beanName = beanName;
            this.beanFactory = beanFactory;
        }

        String getBeanName() {
            return this.beanName;
        }

        BeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        BeanDefinition getBeanDefinition() {
            return this.beanFactory.getBeanDefinition(this.beanName);
        }
    }
}

