/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.builder.CypherFilterBuilder;
import org.springframework.data.repository.query.parser.Part;

public class BetweenComparisonBuilder
extends CypherFilterBuilder {
    public BetweenComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<CypherFilter> build() {
        ArrayList<CypherFilter> filters = new ArrayList<CypherFilter>();
        CypherFilter greaterThan = new CypherFilter();
        greaterThan.setPropertyName(this.propertyName());
        greaterThan.setOwnerEntityType(this.entityType);
        greaterThan.setBooleanOperator(this.booleanOperator);
        greaterThan.setNegated(this.isNegated());
        greaterThan.setComparisonOperator(ComparisonOperator.GREATER_THAN);
        this.setNestedAttributes(this.part, greaterThan);
        filters.add(greaterThan);
        CypherFilter lessThan = new CypherFilter();
        lessThan.setPropertyName(this.propertyName());
        lessThan.setOwnerEntityType(this.entityType);
        lessThan.setBooleanOperator(BooleanOperator.AND);
        lessThan.setNegated(this.isNegated());
        lessThan.setComparisonOperator(ComparisonOperator.LESS_THAN);
        this.setNestedAttributes(this.part, lessThan);
        filters.add(lessThan);
        return filters;
    }
}

