/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.repository.query.parser.Part;

public class CypherFinderQuery
implements DerivedQueryDefinition {
    private Class<?> entityType;
    private Part basePart;
    private List<CypherFilter> cypherFilters = new ArrayList<CypherFilter>();
    private int paramPosition = 0;

    public CypherFinderQuery(Class<?> entityType, Part basePart) {
        this.entityType = entityType;
        this.basePart = basePart;
    }

    @Override
    public Part getBasePart() {
        return this.basePart;
    }

    @Override
    public Filters getFilters() {
        Filters filters = new Filters();
        for (CypherFilter cypherFilter : this.cypherFilters) {
            filters.add(new Filter[]{cypherFilter.toFilter()});
        }
        return filters;
    }

    @Override
    public void addPart(Part part, BooleanOperator booleanOperator) {
        String property = part.getProperty().getSegment();
        CypherFilter parameter = new CypherFilter();
        parameter.setPropertyPosition(this.paramPosition++);
        parameter.setPropertyName(property);
        parameter.setOwnerEntityType(this.entityType);
        parameter.setComparisonOperator(this.convertToComparisonOperator(part.getType()));
        parameter.setNegated(part.getType().name().startsWith("NOT"));
        parameter.setBooleanOperator(booleanOperator);
        if (part.getProperty().next() != null) {
            parameter.setOwnerEntityType(part.getProperty().getOwningType().getType());
            parameter.setNestedPropertyType(part.getProperty().getType());
            parameter.setPropertyName(part.getProperty().getLeafProperty().getSegment());
            parameter.setNestedPropertyName(part.getProperty().getSegment());
        }
        this.cypherFilters.add(parameter);
    }

    private ComparisonOperator convertToComparisonOperator(Part.Type type) {
        switch (type) {
            case GREATER_THAN: {
                return ComparisonOperator.GREATER_THAN;
            }
            case LESS_THAN: {
                return ComparisonOperator.LESS_THAN;
            }
            case REGEX: {
                return ComparisonOperator.MATCHES;
            }
            case LIKE: {
                return ComparisonOperator.LIKE;
            }
            case NOT_LIKE: {
                return ComparisonOperator.LIKE;
            }
        }
        return ComparisonOperator.EQUALS;
    }
}

