/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collections;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.util.TypeInformation;

public class Neo4jMappingContext
extends AbstractMappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jMappingContext.class);
    private final MetaData metaData;

    public Neo4jMappingContext(MetaData metaData) {
        this.metaData = metaData;
        for (ClassInfo classInfo : metaData.persistentEntities()) {
            try {
                this.addPersistentEntity(MetaDataClassLoader.loadClass((String)classInfo.name()));
            }
            catch (ClassNotFoundException e) {
                logger.error("Failed to load class: " + classInfo.name() + " named in ClassInfo due to exception", (Throwable)e);
            }
        }
        logger.info("Neo4jMappingContext initialisation completed");
    }

    protected <T> Neo4jPersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        logger.debug("Creating Neo4jPersistentEntity from type information: {}", typeInformation);
        return new Neo4jPersistentEntity<T>(typeInformation);
    }

    protected Neo4jPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, Neo4jPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        ClassInfo owningClassInfo = this.metaData.classInfo(owner.getType().getName());
        Field propertyField = field;
        if (propertyField == null && owningClassInfo != null && descriptor != null) {
            FieldInfo fieldInfo = owningClassInfo.propertyFieldByName(descriptor.getName());
            if (fieldInfo == null) {
                fieldInfo = owningClassInfo.relationshipFieldByName(descriptor.getName());
            }
            if (fieldInfo != null) {
                propertyField = owningClassInfo.getField(fieldInfo);
            } else {
                logger.debug("Couldn't resolve a concrete field corresponding to property {} on {} ", (Object)descriptor.getName(), (Object)owningClassInfo.name());
            }
        }
        return new Neo4jPersistentProperty(owningClassInfo, propertyField, descriptor, (PersistentEntity<?, Neo4jPersistentProperty>)owner, this.updateSimpleTypeHolder(simpleTypeHolder, propertyField));
    }

    private SimpleTypeHolder updateSimpleTypeHolder(SimpleTypeHolder currentSimpleTypeHolder, Field field) {
        Class<?> fieldType;
        if (field == null) {
            return currentSimpleTypeHolder;
        }
        Class<?> clazz = fieldType = field.getType().isArray() ? field.getType().getComponentType() : field.getType();
        if (this.shouldUpdateSimpleTypes(currentSimpleTypeHolder, field, fieldType)) {
            SimpleTypeHolder updatedSimpleTypeHolder = new SimpleTypeHolder(Collections.singleton(fieldType), currentSimpleTypeHolder);
            this.setSimpleTypeHolder(updatedSimpleTypeHolder);
            return updatedSimpleTypeHolder;
        }
        return currentSimpleTypeHolder;
    }

    private boolean shouldUpdateSimpleTypes(SimpleTypeHolder currentSimpleTypeHolder, Field field, Class<?> rawFieldType) {
        if (field.isAnnotationPresent(Convert.class)) {
            return true;
        }
        if (currentSimpleTypeHolder.isSimpleType(rawFieldType) || rawFieldType.isInterface()) {
            return false;
        }
        if (this.metaData.classInfo(rawFieldType.getName()) == null) {
            logger.info("No class information found in OGM meta-data for {} so treating as simple type for SD Commons", rawFieldType);
            return true;
        }
        return false;
    }
}

