/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import org.neo4j.ogm.exception.InvalidDepthException;
import org.neo4j.ogm.exception.NotFoundException;
import org.neo4j.ogm.metadata.MappingException;
import org.neo4j.ogm.session.result.ResultProcessingException;
import org.neo4j.ogm.session.transaction.TransactionException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.template.UncategorizedGraphStoreException;
import org.springframework.transaction.NoTransactionException;

public class Neo4jOgmExceptionTranslator {
    public static DataAccessException translateExceptionIfPossible(Exception ex) {
        try {
            throw ex;
        }
        catch (NotFoundException nfe) {
            throw new DataRetrievalFailureException(nfe.getMessage(), (Throwable)nfe);
        }
        catch (InvalidDepthException ide) {
            throw new InvalidDataAccessApiUsageException(ide.getMessage(), (Throwable)ide);
        }
        catch (MappingException me) {
            throw new UncategorizedGraphStoreException(me.getMessage(), me);
        }
        catch (ResultProcessingException rpe) {
            throw new DataRetrievalFailureException(rpe.getMessage(), (Throwable)rpe);
        }
        catch (TransactionException te) {
            throw new NoTransactionException(te.getMessage(), (Throwable)te);
        }
        catch (RuntimeException re) {
            throw new UncategorizedGraphStoreException(re.getMessage(), re);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

