/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.HashMap;
import java.util.Iterator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryCreator;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class DerivedGraphRepositoryQuery
implements RepositoryQuery {
    private DerivedQueryDefinition queryDefinition;
    private final GraphQueryMethod graphQueryMethod;
    protected final Session session;

    public DerivedGraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        this.graphQueryMethod = graphQueryMethod;
        this.session = session;
        EntityMetadata info = graphQueryMethod.getEntityInformation();
        PartTree tree = new PartTree(graphQueryMethod.getName(), info.getJavaType());
        this.queryDefinition = (DerivedQueryDefinition)new DerivedQueryCreator(tree, info.getJavaType()).createQuery();
    }

    public Object execute(Object[] parameters) {
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        Class<?> concreteType = this.graphQueryMethod.resolveConcreteReturnType();
        Filters params = this.resolveParams(parameters);
        if (returnType.equals(Void.class)) {
            throw new RuntimeException("Derived Queries must have a return type");
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            return this.session.loadAll(concreteType, params);
        }
        Iterator objectIterator = this.session.loadAll(returnType, params).iterator();
        if (objectIterator.hasNext()) {
            return objectIterator.next();
        }
        return null;
    }

    private Filters resolveParams(Object[] parameters) {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            params.put(i, parameters[i]);
        }
        Filters queryParams = this.queryDefinition.getFilters();
        for (Filter queryParam : queryParams) {
            queryParam.setPropertyValue(params.get(queryParam.getPropertyPosition()));
        }
        return queryParams;
    }

    public QueryMethod getQueryMethod() {
        return this.graphQueryMethod;
    }
}

