/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.session.Session;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.stereotype.Repository;

@Repository
public class GraphRepositoryImpl<T>
implements GraphRepository<T> {
    private static final int DEFAULT_QUERY_DEPTH = 1;
    private final Class<T> clazz;
    private final Session session;

    public GraphRepositoryImpl(Class<T> clazz, Session session) {
        this.clazz = clazz;
        this.session = session;
    }

    public <S extends T> S save(S entity) {
        this.session.save(entity);
        return entity;
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        for (S entity : entities) {
            this.session.save(entity);
        }
        return null;
    }

    public T findOne(Long id) {
        return (T)this.session.load(this.clazz, id);
    }

    public boolean exists(Long id) {
        return this.findOne(id) != null;
    }

    public long count() {
        return this.session.countEntitiesOfType(this.clazz);
    }

    public void delete(Long id) {
        T o = this.findOne(id);
        if (o != null) {
            this.session.delete(o);
        }
    }

    public void delete(T t) {
        this.session.delete(t);
    }

    public void delete(Iterable<? extends T> ts) {
        for (T t : ts) {
            this.session.delete(t);
        }
    }

    public void deleteAll() {
        this.session.deleteAll(this.clazz);
    }

    @Override
    public <S extends T> S save(S s, int depth) {
        this.session.save(s, depth);
        return s;
    }

    @Override
    public <S extends T> Iterable<S> save(Iterable<S> ses, int depth) {
        this.session.save(ses, depth);
        return null;
    }

    @Override
    public T findOne(Long id, int depth) {
        return (T)this.session.load(this.clazz, id, depth);
    }

    @Override
    public Iterable<T> findAll() {
        return this.findAll(1);
    }

    @Override
    public Iterable<T> findAll(int depth) {
        return this.session.loadAll(this.clazz, depth);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> longs) {
        return this.findAll(longs, 1);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> ids, int depth) {
        return this.session.loadAll(this.clazz, (Collection)ids, depth);
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        return this.findAll(sort, 1);
    }

    @Override
    public Iterable<T> findAll(Sort sort, int depth) {
        return this.session.loadAll(this.clazz, this.convert(sort), depth);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> ids, Sort sort) {
        return this.findAll(ids, sort, 1);
    }

    @Override
    public Iterable<T> findAll(Iterable<Long> ids, Sort sort, int depth) {
        return this.session.loadAll(this.clazz, (Collection)ids, this.convert(sort), depth);
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return this.findAll(pageable, 1);
    }

    @Override
    public Page<T> findAll(Pageable pageable, int depth) {
        Collection data = this.session.loadAll(this.clazz, this.convert(pageable.getSort()), new Pagination(pageable.getPageNumber(), pageable.getPageSize()), depth);
        return this.updatePage(pageable, new ArrayList(data));
    }

    private SortOrder convert(Sort sort) {
        SortOrder sortOrder = new SortOrder();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    sortOrder.add(new String[]{order.getProperty()});
                    continue;
                }
                sortOrder.add(SortOrder.Direction.DESC, new String[]{order.getProperty()});
            }
        }
        return sortOrder;
    }

    private Page<T> updatePage(Pageable pageable, List<T> results) {
        int pageSize = pageable.getPageSize();
        int pageOffset = pageable.getOffset();
        int total = pageOffset + results.size() + (results.size() == pageSize ? pageSize : 0);
        return new PageImpl(results, pageable, (long)total);
    }
}

