/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.EntityIndexCreator;
import org.springframework.data.neo4j.support.schema.SchemaIndexProvider;

public class DefaultEntityIndexCreator
implements EntityIndexCreator {
    private IndexProvider indexProvider;
    private SchemaIndexProvider schemaIndexProvider;
    private boolean labelBased = true;

    public DefaultEntityIndexCreator(IndexProvider indexProvider, SchemaIndexProvider schemaIndexProvider) {
        this(indexProvider, schemaIndexProvider, true);
    }

    public DefaultEntityIndexCreator(IndexProvider indexProvider, SchemaIndexProvider schemaIndexProvider, boolean labelBased) {
        this.indexProvider = indexProvider;
        this.schemaIndexProvider = schemaIndexProvider;
        this.labelBased = labelBased;
    }

    @Override
    public void ensureEntityIndexes(Neo4jPersistentEntity<?> entity) {
        final Class entityType = entity.getType();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

            public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                if (property.isIndexed() && property.getIndexInfo().isLabelBased()) {
                    DefaultEntityIndexCreator.this.schemaIndexProvider.createIndex(property);
                }
            }
        });
        if (!this.labelBased) {
            this.indexProvider.getIndex(entity, null, IndexType.SIMPLE);
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

            public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                if (property.isIndexed() && !property.getIndexInfo().isLabelBased()) {
                    DefaultEntityIndexCreator.this.indexProvider.getIndex(property, entityType);
                }
            }
        });
    }
}

