/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;

public class BasePackageScanner {
    public static Set<String> scanBasePackage(String basePackage) {
        return BasePackageScanner.scanBasePackages(basePackage.split(","));
    }

    public static Set<String> scanBasePackages(String ... basePackages) {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(NodeEntity.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RelationshipEntity.class));
        ManagedSet classes = new ManagedSet();
        for (String basePackage : basePackages) {
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                classes.add(candidate.getBeanClassName());
            }
        }
        return classes;
    }

    public static Set<? extends Class<?>> scanBasePackageForClasses(String ... basePackages) throws ClassNotFoundException {
        HashSet<Class> classes = new HashSet<Class>();
        for (String basePackage : basePackages) {
            for (String className : BasePackageScanner.scanBasePackage(basePackage)) {
                classes.add(BasePackageScanner.loadClass(className));
            }
        }
        return classes;
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }
}

