/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class GenericObjectToObjectConverter
implements GenericConverter {
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Class sourceClass = sourceType.getType();
        Class targetClass = targetType.getType();
        Method method = GenericObjectToObjectConverter.getValueOfMethodOn(targetClass, sourceClass);
        try {
            if (method != null) {
                ReflectionUtils.makeAccessible((Method)method);
                return method.invoke(null, source);
            }
            Constructor<?> constructor = GenericObjectToObjectConverter.getConstructor(targetClass, sourceClass);
            if (constructor != null) {
                return constructor.newInstance(source);
            }
        }
        catch (InvocationTargetException ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
        throw new IllegalStateException("No static valueOf(" + sourceClass.getName() + ") method or Constructor(" + sourceClass.getName() + ") exists on " + targetClass.getName());
    }

    private static Method getValueOfMethodOn(Class<?> clazz, Class<?> sourceParameterType) {
        return ClassUtils.getStaticMethod(clazz, (String)"valueOf", (Class[])new Class[]{sourceParameterType});
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> sourceParameterType) {
        return ClassUtils.getConstructorIfAvailable(clazz, (Class[])new Class[]{sourceParameterType});
    }
}

