/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class ConfigurationCheck
implements ApplicationListener<ContextStartedEvent> {
    Neo4jTemplate template;
    PlatformTransactionManager transactionManager;

    public ConfigurationCheck(Neo4jTemplate template, PlatformTransactionManager transactionManager) {
        this.template = template;
        this.transactionManager = transactionManager;
    }

    public void onApplicationEvent(ContextStartedEvent event) {
        this.checkConfiguration();
    }

    private void checkConfiguration() {
        this.checkInjection();
        this.checkSpringTransactionManager();
        this.checkNeo4jTransactionManager();
    }

    private void checkInjection() {
        if (this.template.getGraphDatabaseService() == null) {
            throw new BeanCreationException("graphDatabaseService not correctly configured, please refer to the manual, setup section");
        }
    }

    private void checkSpringTransactionManager() {
        try {
            TransactionStatus transaction = this.transactionManager.getTransaction(null);
            IteratorUtil.count((Iterable)this.template.getGraphDatabaseService().getRelationshipTypes());
            this.transactionManager.commit(transaction);
        }
        catch (Exception e) {
            throw new BeanCreationException("transactionManager not correctly configured, please refer to the manual, setup section", (Throwable)e);
        }
    }

    private void checkNeo4jTransactionManager() {
        Transaction tx = null;
        try {
            tx = this.template.getGraphDatabase().beginTx();
            IteratorUtil.count((Iterable)this.template.getGraphDatabaseService().getRelationshipTypes());
            tx.success();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.failure();
            }
            throw new BeanCreationException("transactionManager not correctly configured, please refer to the manual, setup section", (Throwable)e);
        }
        finally {
            try {
                if (tx != null) {
                    tx.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

