/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.community.LockException;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.UncategorizedGraphStoreException;
import org.springframework.data.neo4j.mapping.InvalidEntityTypeException;

public class Neo4jExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        try {
            throw ex;
        }
        catch (IllegalArgumentException iae) {
            if (iae.getCause() != null && iae.getCause() instanceof InvalidEntityTypeException) {
                throw (InvalidEntityTypeException)((Object)iae.getCause());
            }
            throw new InvalidDataAccessApiUsageException(iae.getMessage(), (Throwable)iae);
        }
        catch (ConstraintViolationException cve) {
            throw new DataIntegrityViolationException(cve.getMessage(), (Throwable)cve);
        }
        catch (DataAccessException dae) {
            throw dae;
        }
        catch (NotInTransactionException nit) {
            throw new InvalidDataAccessApiUsageException(nit.getMessage(), (Throwable)nit);
        }
        catch (TransactionFailureException tfe) {
            throw new UncategorizedGraphStoreException(tfe.getMessage(), tfe);
        }
        catch (IllegalResourceException ire) {
            throw new InvalidDataAccessResourceUsageException(ire.getMessage(), (Throwable)ire);
        }
        catch (NotFoundException nfe) {
            throw new DataRetrievalFailureException(nfe.getMessage(), (Throwable)nfe);
        }
        catch (DeadlockDetectedException dde) {
            throw new ConcurrencyFailureException(dde.getMessage(), (Throwable)dde);
        }
        catch (LockException le) {
            throw new ConcurrencyFailureException(le.getMessage(), (Throwable)le);
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().equals("org.neo4j.kernel.impl.core.ReadOnlyDbException")) {
                throw new InvalidDataAccessResourceUsageException(e.getMessage(), (Throwable)e);
            }
            if (e.getClass().getName().equals("org.neo4j.index.impl.lucene.QueryNotPossibleException")) {
                throw new ConcurrencyFailureException(e.getMessage(), (Throwable)e);
            }
            if (e.getClass().getName().equals("org.neo4j.kernel.impl.nioneo.store.StoreFailureException")) {
                throw new DataAccessResourceFailureException(e.getMessage(), (Throwable)e);
            }
            if (e.getClass().getName().equals("org.neo4j.kernel.impl.persistence.IdGenerationFailedException")) {
                throw new NonTransientDataAccessResourceException(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }
}

