/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;
import org.springframework.util.Assert;

public class AuditingEventListener
implements ApplicationListener<BeforeSaveEvent<Object>> {
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandler;

    public AuditingEventListener(ObjectFactory<IsNewAwareAuditingHandler> auditingHandler) {
        Assert.notNull(auditingHandler, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandler = auditingHandler;
    }

    public void onApplicationEvent(BeforeSaveEvent<Object> event) {
        Object entity = event.getEntity();
        ((IsNewAwareAuditingHandler)this.auditingHandler.getObject()).markAudited(entity);
    }
}

