/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.springframework.beans.factory.FactoryBean;

public class GraphDatabaseServiceFactoryBean
implements FactoryBean<GraphDatabaseService> {
    private String path;
    private Map<String, String> config;
    private GraphDatabaseService database;

    public GraphDatabaseServiceFactoryBean(String path, Map<String, String> config) {
        this.path = path;
        this.config = config;
    }

    public GraphDatabaseServiceFactoryBean(String path) {
        this.path = path;
    }

    public GraphDatabaseServiceFactoryBean() {
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public GraphDatabaseService getObject() throws Exception {
        if (this.database != null) {
            return this.database;
        }
        this.database = this.createDatabase();
        return this.database;
    }

    private GraphDatabaseService createDatabase() {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path);
        if (this.config != null) {
            builder.setConfig(this.config);
        }
        return builder.newGraphDatabase();
    }

    public Class<?> getObjectType() {
        return GraphDatabaseService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void shutdown() {
        if (this.database != null) {
            this.database.shutdown();
            this.database = null;
        }
    }
}

