/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.GraphBackedEntityIterableWrapper;
import org.springframework.data.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.neo4j.fieldaccess.RelationshipEntities;
import org.springframework.data.neo4j.fieldaccess.RelationshipHelper;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class RelatedToViaCollectionFieldAccessorFactory
implements FieldAccessorFactory {
    private Neo4jTemplate template;

    public RelatedToViaCollectionFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        if (!property.isRelationship()) {
            return false;
        }
        return property.getRelationshipInfo().isRelatedToVia() && property.getRelationshipInfo().isCollection();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new RelatedToViaCollectionFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), relationshipInfo.getTargetType().getType(), this.template, property);
    }

    public static class RelatedToViaCollectionFieldAccessor
    implements FieldAccessor {
        private final boolean isMutableCollection;
        private final Class<?> relatedType;
        private final Neo4jTemplate template;
        private final Neo4jPersistentProperty property;
        private final RelationshipHelper relationshipHelper;
        private final RelationshipEntities relationshipEntities;

        public RelatedToViaCollectionFieldAccessor(RelationshipType type, Direction direction, Class<?> relatedType, Neo4jTemplate template, Neo4jPersistentProperty property) {
            this.relationshipHelper = new RelationshipHelper(template, direction, type);
            this.relatedType = relatedType;
            this.template = template;
            this.property = property;
            this.isMutableCollection = Collection.class.isAssignableFrom(property.getType());
            this.relationshipEntities = new RelationshipEntities(this.relationshipHelper, property);
        }

        @Override
        public Object getDefaultValue() {
            if (List.class.isAssignableFrom(this.property.getType())) {
                return new ArrayList();
            }
            return new HashSet();
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            if (!this.isMutableCollection) {
                throw new InvalidDataAccessApiUsageException("Cannot set read-only relationship entity field.");
            }
            Node startNode = this.relationshipHelper.checkAndGetNode(entity);
            if (newVal == null) {
                return null;
            }
            Map<Node, Object> endNodeToEntityMapping = this.loadEndNodeToRelationshipEntityMapping(newVal, startNode);
            this.relationshipHelper.removeMissingRelationshipsInStoreAndKeepOnlyNewRelationShipsInSet(startNode, endNodeToEntityMapping.keySet(), null);
            this.persistEntities(endNodeToEntityMapping.values(), this.relationshipHelper.getRelationshipType());
            return this.createManagedSet(entity, (Set)newVal, this.property.obtainMappingPolicy(mappingPolicy));
        }

        private void persistEntities(Collection<Object> relationshipEntities, RelationshipType relationshipType) {
            for (Object entity : relationshipEntities) {
                this.template.save(entity, relationshipType, this.template.getMappingPolicy(entity));
            }
        }

        protected Map<Node, Object> loadEndNodeToRelationshipEntityMapping(Object newVal, Node startNode) {
            if (!(newVal instanceof Iterable)) {
                throw new IllegalArgumentException("New value must be at least an Iterable, was: " + newVal.getClass());
            }
            Iterable iterable = (Iterable)newVal;
            return this.relationshipEntities.loadEndNodeToRelationshipEntityMapping(startNode, iterable, this.relatedType);
        }

        @Override
        public boolean isWriteable(Object entity) {
            return this.isMutableCollection;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Node node = this.relationshipHelper.checkAndGetNode(entity);
            GraphBackedEntityIterableWrapper<Relationship, ?> result = this.loadRelationshipEntities(node);
            if (this.isMutableCollection) {
                ManagedFieldAccessorSet managedSet = this.createManagedSet(entity, (Set)IteratorUtil.addToCollection(result, new HashSet()), this.property.obtainMappingPolicy(mappingPolicy));
                return DoReturn.doReturn(managedSet);
            }
            return DoReturn.doReturn(result);
        }

        protected <T> ManagedFieldAccessorSet<T> createManagedSet(Object entity, Set<T> result, MappingPolicy mappingPolicy) {
            return ManagedFieldAccessorSet.create(entity, result, mappingPolicy, this.property, this.template, this);
        }

        private GraphBackedEntityIterableWrapper<Relationship, ?> loadRelationshipEntities(Node node) {
            return GraphBackedEntityIterableWrapper.create(this.relationshipHelper.getRelationships(node), this.relatedType, this.template);
        }
    }
}

