/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;

public class IndexInfo {
    private String indexName;
    private IndexType indexType;
    private final String fieldName;
    private final Indexed.Level level;
    private String indexKey;
    private final boolean unique;
    private boolean numeric;
    private Indexed annotation;
    private Neo4jPersistentProperty property;

    public IndexInfo(Indexed annotation, Neo4jPersistentProperty property) {
        this.annotation = annotation;
        this.property = property;
        this.indexType = annotation.indexType();
        this.fieldName = annotation.fieldName();
        this.indexKey = this.fieldName.isEmpty() ? property.getNeo4jPropertyName() : this.fieldName;
        this.unique = annotation.unique();
        this.level = annotation.level();
        this.numeric = annotation.numeric();
    }

    private String determineLabelIndexName(Indexed annotation, Neo4jPersistentProperty property) {
        if (!annotation.indexName().isEmpty()) {
            throw new MappingException("No index name allowed on label based indexes, property: " + property.getOwner().getName() + "." + property.getName());
        }
        Neo4jPersistentEntity<?> entity = property.getOwner();
        StoredEntityType entityType = entity.getEntityType();
        switch (annotation.level()) {
            case CLASS: {
                Class<?> declaringClass = property.getField().getDeclaringClass();
                return entityType != null ? entityType.findByTypeClass(declaringClass).getAlias().toString() : this.doBestGuessLabelName(entity);
            }
            case INSTANCE: {
                return entityType != null ? entityType.getAlias().toString() : this.doBestGuessLabelName(entity);
            }
            case GLOBAL: {
                throw new MappingException("No global index for label based indexes");
            }
        }
        return entityType.getAlias().toString();
    }

    private String doBestGuessLabelName(Neo4jPersistentEntity<?> entity) {
        if (entity.getTypeAlias() != null) {
            return (String)entity.getTypeAlias();
        }
        return entity.getType().getSimpleName();
    }

    private String determineIndexName(Indexed annotation, Neo4jPersistentProperty property) {
        String providedIndexName = annotation.indexName().isEmpty() ? null : annotation.indexName();
        Class<?> declaringClass = property.getField().getDeclaringClass();
        Class instanceType = property.getOwner().getType();
        return Indexed.Name.get(annotation.level(), declaringClass, providedIndexName, instanceType);
    }

    public boolean isLabelBased() {
        return this.indexType.isLabelBased();
    }

    public String getIndexName() {
        if (this.indexName == null) {
            this.indexName = this.isLabelBased() ? this.determineLabelIndexName(this.annotation, this.property) : this.determineIndexName(this.annotation, this.property);
        }
        return this.indexName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isFullText() {
        return this.indexType == IndexType.FULLTEXT;
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isNumeric() {
        return this.numeric;
    }
}

