/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.LinkedHashSet;
import java.util.Set;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.neo4j.support.mapping.WrappedIterableClosableIterable;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.typerepresentation.LabelBasedStrategyCypherHelper;

public class LabelBasedNodeTypeRepresentationStrategy
implements NodeTypeRepresentationStrategy {
    public static final String SDN_LABEL_STRATEGY = "SDN_LABEL_STRATEGY";
    public static final String LABELSTRATEGY_PREFIX = "_";
    protected GraphDatabase graphDb;
    protected final Class<Node> clazz;
    protected final LabelBasedStrategyCypherHelper cypherHelper;
    protected CypherQueryEngine queryEngine;

    public LabelBasedNodeTypeRepresentationStrategy(GraphDatabase graphDb) {
        this.graphDb = graphDb;
        this.clazz = Node.class;
        this.queryEngine = graphDb.queryEngine();
        this.cypherHelper = new LabelBasedStrategyCypherHelper(this.queryEngine);
        this.markSDNLabelStrategyInUse();
    }

    @Override
    public void writeTypeTo(Node state, StoredEntityType type) {
        if (type == null || !type.isNodeEntity()) {
            return;
        }
        Label sdnLabel = DynamicLabel.label((String)(LABELSTRATEGY_PREFIX + type.getAlias()));
        if (state.hasLabel(sdnLabel)) {
            return;
        }
        this.addLabelsForEntityHierarchy(state, type);
    }

    private void addLabelsForEntityHierarchy(Node state, StoredEntityType type) {
        this.cypherHelper.setLabelsOnNode(state.getId(), this.getAllHierarchyLabelsForType(type));
    }

    private Set<String> getAllHierarchyLabelsForType(StoredEntityType type) {
        String alias = type.getAlias().toString();
        Set<String> labels = this.collectSuperTypeLabels(type, new LinkedHashSet<String>());
        labels.add(alias);
        labels.add(LABELSTRATEGY_PREFIX + alias);
        return labels;
    }

    private Set<String> collectSuperTypeLabels(StoredEntityType type, Set<String> labels) {
        if (type == null) {
            return labels;
        }
        for (StoredEntityType superType : type.getSuperTypes()) {
            labels.add(superType.getAlias().toString());
            this.collectSuperTypeLabels(superType, labels);
        }
        return labels;
    }

    private void markSDNLabelStrategyInUse() {
        this.cypherHelper.createMarkerLabel(SDN_LABEL_STRATEGY);
    }

    @Override
    public <U> ClosableIterable<Node> findAll(StoredEntityType type) {
        Iterable<Node> rin = this.cypherHelper.getNodesWithLabel(type.getAlias().toString());
        return new WrappedIterableClosableIterable<Node>(rin);
    }

    @Override
    public long count(StoredEntityType type) {
        return this.cypherHelper.countNodesWithLabel(type.getAlias().toString());
    }

    @Override
    public Object readAliasFrom(Node state) {
        if (state == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Iterable<String> labels = this.cypherHelper.getLabelsForNode(state.getId());
        for (String label : labels) {
            if (!label.startsWith(LABELSTRATEGY_PREFIX)) continue;
            return label.substring(LABELSTRATEGY_PREFIX.length());
        }
        throw new IllegalStateException("No primary SDN label exists .. (i.e one with starting with _) ");
    }

    @Override
    public void preEntityRemoval(Node state) {
    }

    @Override
    public boolean isLabelBased() {
        return true;
    }

    public static boolean isStrategyAlreadyInUse(GraphDatabase graphDatabaseService) {
        return graphDatabaseService.getAllLabelNames().contains(SDN_LABEL_STRATEGY);
    }
}

