/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;

public class FieldAccessorFactoryProviders<T> {
    private final List<FieldAccessorFactoryProvider<T>> fieldAccessorFactoryProviders = new ArrayList<FieldAccessorFactoryProvider<T>>();
    private Neo4jPersistentProperty idProperty;

    FieldAccessorFactoryProviders() {
    }

    public Map<Neo4jPersistentProperty, FieldAccessor> getFieldAccessors() {
        int count = this.fieldAccessorFactoryProviders.size();
        HashMap<Neo4jPersistentProperty, FieldAccessor> result = new HashMap<Neo4jPersistentProperty, FieldAccessor>(count, 1.0f);
        for (int i = 0; i < count; ++i) {
            FieldAccessorFactoryProvider<T> fieldAccessorFactoryProvider = this.fieldAccessorFactoryProviders.get(i);
            FieldAccessor accessor = fieldAccessorFactoryProvider.accessor();
            result.put(fieldAccessorFactoryProvider.getProperty(), accessor);
        }
        return result;
    }

    public Map<Neo4jPersistentProperty, List<FieldAccessListener>> getFieldAccessListeners() {
        int count = this.fieldAccessorFactoryProviders.size();
        HashMap<Neo4jPersistentProperty, List<FieldAccessListener>> result = new HashMap<Neo4jPersistentProperty, List<FieldAccessListener>>(count, 1.0f);
        for (int i = 0; i < count; ++i) {
            FieldAccessorFactoryProvider<T> fieldAccessorFactoryProvider = this.fieldAccessorFactoryProviders.get(i);
            List<FieldAccessListener> listeners = fieldAccessorFactoryProvider.listeners();
            result.put(fieldAccessorFactoryProvider.getProperty(), listeners);
        }
        return result;
    }

    public void add(Neo4jPersistentProperty property, FieldAccessorFactory fieldAccessorFactory, List<FieldAccessorListenerFactory> listenerFactories) {
        this.fieldAccessorFactoryProviders.add(new FieldAccessorFactoryProvider(property, fieldAccessorFactory, listenerFactories));
        if (property.isIdProperty()) {
            this.idProperty = property;
        }
    }

    public Neo4jPersistentProperty getIdProperty() {
        return this.idProperty;
    }

    static class FieldAccessorFactoryProvider<E> {
        private final Neo4jPersistentProperty property;
        private final FieldAccessorFactory fieldAccessorFactory;
        private final List<FieldAccessorListenerFactory> fieldAccessorListenerFactories;

        FieldAccessorFactoryProvider(Neo4jPersistentProperty property, FieldAccessorFactory fieldAccessorFactory, List fieldAccessorListenerFactories) {
            this.property = property;
            this.fieldAccessorFactory = fieldAccessorFactory;
            this.fieldAccessorListenerFactories = fieldAccessorListenerFactories;
        }

        public FieldAccessor accessor() {
            if (this.fieldAccessorFactory == null) {
                return null;
            }
            return this.fieldAccessorFactory.forField(this.property);
        }

        public List<FieldAccessListener> listeners() {
            if (this.fieldAccessorListenerFactories == null) {
                return null;
            }
            int count = this.fieldAccessorListenerFactories.size();
            ArrayList<FieldAccessListener> listeners = new ArrayList<FieldAccessListener>(count);
            for (int i = 0; i < count; ++i) {
                listeners.add(this.fieldAccessorListenerFactories.get(i).forField(this.property));
            }
            return listeners;
        }

        public Neo4jPersistentProperty getProperty() {
            return this.property;
        }
    }
}

