/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.mapping.EntityAlias;
import org.springframework.data.util.TypeInformation;

public class StoredEntityType {
    private final Object alias;
    private final Neo4jPersistentEntity<?> entity;
    private final Collection<StoredEntityType> superTypes;
    private final EntityAlias entityAlias;
    private final Class<?> type;
    private final boolean isNodeEntity;
    private final boolean isRelationshipEntity;

    StoredEntityType(Neo4jPersistentEntity<?> entity, Collection<Neo4jPersistentEntity<?>> superTypeEntities, EntityAlias entityAlias) {
        this.entity = entity;
        this.entityAlias = entityAlias;
        this.superTypes = this.collectSuperTypes(superTypeEntities);
        this.alias = this.createAlias();
        this.type = this.entity.getType();
        this.isNodeEntity = this.entity.isNodeEntity();
        this.isRelationshipEntity = this.entity.isRelationshipEntity();
    }

    private Collection<StoredEntityType> collectSuperTypes(Collection<Neo4jPersistentEntity<?>> superTypeEntities) {
        ArrayList<StoredEntityType> result = new ArrayList<StoredEntityType>(superTypeEntities.size());
        for (Neo4jPersistentEntity<?> superTypeEntity : superTypeEntities) {
            result.add(superTypeEntity.getEntityType());
        }
        return result;
    }

    protected Object createAlias() {
        return this.entityAlias.createAlias(this.entity);
    }

    public Object getAlias() {
        return this.alias;
    }

    public Neo4jPersistentEntity<?> getEntity() {
        return this.entity;
    }

    public Collection<StoredEntityType> getSuperTypes() {
        return this.superTypes;
    }

    boolean matchesAlias(Object alias) {
        if (alias == null) {
            return false;
        }
        Class<?> type = this.getType();
        if (alias instanceof String) {
            return this.getAlias().equals(alias) || type.getName().equals(alias);
        }
        if (alias instanceof Class) {
            return type.equals(alias);
        }
        if (alias instanceof TypeInformation) {
            return this.entity.getTypeInformation().equals(alias);
        }
        return alias.equals(this.getAlias());
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isNodeEntity() {
        return this.isNodeEntity;
    }

    public boolean isRelationshipEntity() {
        return this.isRelationshipEntity;
    }

    public String toString() {
        return String.format("StoredEntityType for %s with alias %s", this.getType(), this.getAlias());
    }

    public StoredEntityType findByTypeClass(Class type) {
        if (this.getType().equals(type)) {
            return this;
        }
        for (StoredEntityType superType : this.superTypes) {
            StoredEntityType foundType = superType.findByTypeClass(type);
            if (foundType == null) continue;
            return foundType;
        }
        return null;
    }
}

