/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Iterator;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class ReferenceNodes {
    public static final String ROOT_NAME = "root";
    private static ExecutionEngine engine;
    private static GraphDatabaseService dbRef;

    public static Node getReferenceNode(GraphDatabaseService db) {
        return ReferenceNodes.getReferenceNode(db, ROOT_NAME);
    }

    public static Node getReferenceNode(GraphDatabase db) {
        return ReferenceNodes.getReferenceNode(db, ROOT_NAME);
    }

    public static Node obtainReferenceNode(GraphDatabaseService db) {
        return ReferenceNodes.obtainReferenceNode(db, ROOT_NAME);
    }

    public static Node obtainReferenceNode(GraphDatabase db) {
        return ReferenceNodes.obtainReferenceNode(db, ROOT_NAME);
    }

    public static Node obtainReferenceNode(GraphDatabaseService db, String name) {
        return ReferenceNodes.executeQuery(db, name, "MERGE (ref:ReferenceNode {name:{name}}) RETURN ref");
    }

    private static Node executeQuery(GraphDatabaseService db, String name, String query) {
        if (engine == null || db != dbRef) {
            engine = new ExecutionEngine(db);
            dbRef = db;
        }
        ExecutionResult result = engine.execute(query, MapUtil.map((Object[])new Object[]{"name", name}));
        return (Node)IteratorUtil.single((Iterator)result.columnAs("ref"));
    }

    public static Node getReferenceNode(GraphDatabaseService db, String name) {
        return ReferenceNodes.executeQuery(db, name, "MATCH (ref:ReferenceNode {name:{name}}) RETURN ref");
    }

    public static Node obtainReferenceNode(GraphDatabase db, String name) {
        return ReferenceNodes.executeQuery(db, name, "MERGE (ref:ReferenceNode {name:{name}}) RETURN ref");
    }

    private static Node executeQuery(GraphDatabase db, String name, String query) {
        QueryEngine engine = db.queryEngineFor(QueryType.Cypher);
        return engine.query(query, MapUtil.map((Object[])new Object[]{"name", name})).to(Node.class).singleOrNull();
    }

    public static Node getReferenceNode(GraphDatabase db, String name) {
        return ReferenceNodes.executeQuery(db, name, "MATCH (ref:ReferenceNode {name:{name}}) RETURN ref");
    }
}

