/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.query.CypherGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.DerivedCypherRepositoryQuery;
import org.springframework.data.neo4j.repository.query.ParameterResolver;
import org.springframework.data.neo4j.support.GenericTypeExtractor;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.StringUtils;

public class GraphQueryMethod
extends QueryMethod {
    private final Method method;
    private final NamedQueries namedQueries;
    private final Neo4jMappingContext mappingContext;
    private final Query queryAnnotation;

    public GraphQueryMethod(Method method, RepositoryMetadata metadata, NamedQueries namedQueries, Neo4jMappingContext mappingContext) {
        super(method, metadata);
        this.method = method;
        this.namedQueries = namedQueries;
        this.mappingContext = mappingContext;
        this.queryAnnotation = method.getAnnotation(Query.class);
    }

    public String getQueryString() {
        return this.queryAnnotation != null ? this.queryAnnotation.value() : this.getNamedQuery(this.getNamedQueryName());
    }

    public String getNamedQueryName() {
        String annotatedName = this.queryAnnotation != null ? this.queryAnnotation.queryName() : null;
        return StringUtils.hasText((String)annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    public String getCountQueryString() {
        return this.queryAnnotation != null ? this.queryAnnotation.countQuery() : this.getNamedQuery(this.getNamedCountQueryName());
    }

    public boolean isValid() {
        return this.getQueryString() != null;
    }

    private String getNamedQuery(String namedQueryName) {
        if (this.namedQueries.hasQuery(namedQueryName)) {
            return this.namedQueries.getQuery(namedQueryName);
        }
        return null;
    }

    String getNamedCountQueryName() {
        String annotatedName = this.queryAnnotation != null ? this.queryAnnotation.countQueryName() : null;
        return StringUtils.hasText((String)annotatedName) ? annotatedName : this.getNamedQueryName() + ".count";
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    protected Map<String, Object> resolveParams(ParameterAccessor accessor, ParameterResolver parameterResolver) {
        Map<Parameter, Object> parameters = parameterResolver.resolveParameters(this.getParameterValues(accessor));
        return this.nameParameters(parameters);
    }

    private Map<Parameter, Object> getParameterValues(ParameterAccessor accessor) {
        LinkedHashMap<Parameter, Object> parameters = new LinkedHashMap<Parameter, Object>();
        for (Parameter parameter : this.getParameters().getBindableParameters()) {
            Object value = accessor.getBindableValue(parameter.getIndex());
            parameters.put(parameter, value);
        }
        return parameters;
    }

    private Map<String, Object> nameParameters(Map<Parameter, Object> parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Map.Entry<Parameter, Object> entry : parameters.entrySet()) {
            params.put(this.getParameterName(entry.getKey()), entry.getValue());
        }
        return params;
    }

    private String getParameterName(Parameter parameter) {
        String parameterName = parameter.getName();
        if (parameterName != null) {
            return parameterName;
        }
        return String.valueOf(parameter.getIndex());
    }

    Class<?> getCompoundType() {
        Class<?> elementClass = this.getElementClass();
        if (elementClass != null) {
            return elementClass;
        }
        return GenericTypeExtractor.resolveReturnedType(this.method);
    }

    private Class<?> getElementClass() {
        if (!this.hasAnnotation() || this.queryAnnotation.elementClass().equals(Object.class)) {
            return null;
        }
        return this.queryAnnotation.elementClass();
    }

    public boolean hasAnnotation() {
        return this.queryAnnotation != null;
    }

    boolean isIterableResult() {
        return this.hasResultOfType(Iterable.class);
    }

    public RepositoryQuery createQuery(Neo4jTemplate template) {
        if (this.queryAnnotation == null) {
            if (this.namedQueries.hasQuery(this.getNamedQueryName())) {
                return new CypherGraphRepositoryQuery(this, template);
            }
            return new DerivedCypherRepositoryQuery(this.mappingContext, this, template);
        }
        switch (this.queryAnnotation.type()) {
            case Cypher: {
                return new CypherGraphRepositoryQuery(this, template);
            }
        }
        throw new IllegalStateException("@Query Annotation has to be configured as Cypher Query");
    }

    public boolean isSetResult() {
        Class<Set> superClass = Set.class;
        return this.hasResultOfType(superClass);
    }

    public boolean hasResultOfType(Class<?> superClass) {
        return superClass.isAssignableFrom(this.getReturnType());
    }

    public boolean isCollectionResult() {
        return this.hasResultOfType(Collection.class);
    }

    public String toString() {
        return "Repository-Graph-Query-Method for " + this.method;
    }
}

