/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.query.QueryEngine;

public interface GraphDatabase {
    public Node getNodeById(long var1);

    public Node createNode(Map<String, Object> var1);

    public Node getOrCreateNode(String var1, String var2, Object var3, Map<String, Object> var4);

    public Relationship getRelationshipById(long var1);

    public Relationship createRelationship(Node var1, Node var2, RelationshipType var3, Map<String, Object> var4);

    public Relationship getOrCreateRelationship(String var1, String var2, Object var3, Node var4, Node var5, String var6, Map<String, Object> var7);

    public void remove(Node var1);

    public void remove(Relationship var1);

    public <T extends PropertyContainer> Index<T> getIndex(String var1);

    public <T extends PropertyContainer> Index<T> createIndex(Class<T> var1, String var2, IndexType var3);

    public TraversalDescription traversalDescription();

    public <T> QueryEngine<T> queryEngineFor(QueryType var1);

    public <T> QueryEngine<T> queryEngineFor(QueryType var1, ResultConverter var2);

    public void setConversionService(ConversionService var1);

    public void setResultConverter(ResultConverter var1);

    public boolean transactionIsRunning();

    public TransactionManager getTransactionManager();

    public Transaction beginTx();

    public void shutdown();

    public Collection<String> getAllLabelNames();
}

