/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import org.neo4j.graphdb.Node;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DetachedEntityState;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.node.EntityStateFactory;
import org.springframework.data.neo4j.support.node.NodeEntityState;

public class NodeEntityStateFactory
implements EntityStateFactory<Node> {
    protected final FieldAccessorFactoryFactory nodeDelegatingFieldAccessorFactory;
    protected final Neo4jMappingContext mappingContext;

    public NodeEntityStateFactory(Neo4jMappingContext mappingContext, FieldAccessorFactoryFactory nodeDelegatingFieldAccessorFactory) {
        this.nodeDelegatingFieldAccessorFactory = nodeDelegatingFieldAccessorFactory;
        this.mappingContext = mappingContext;
    }

    @Override
    public EntityState<Node> getEntityState(Object entity, boolean detachable, Neo4jTemplate template) {
        Class<?> entityType = entity.getClass();
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        NodeEntityState nodeEntityState = new NodeEntityState(null, entity, entityType, template, this.nodeDelegatingFieldAccessorFactory.provideFactoryFor(template), persistentEntity);
        if (!detachable) {
            return nodeEntityState;
        }
        return new DetachedEntityState<Node>(nodeEntityState, template);
    }
}

