/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import java.util.HashMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.tooling.GlobalGraphOperations;
import org.springframework.data.neo4j.core.UncategorizedGraphStoreException;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public abstract class Neo4jHelper {
    public static void cleanDb(Neo4jTemplate template) {
        Neo4jHelper.cleanDb(template.getGraphDatabaseService());
    }

    public static void dumpDb(GraphDatabaseService gds) {
        GlobalGraphOperations globalGraphOperations = GlobalGraphOperations.at((GraphDatabaseService)gds);
        for (Node node : globalGraphOperations.getAllNodes()) {
            System.out.println(Neo4jHelper.dump((PropertyContainer)node));
        }
        for (Node node : globalGraphOperations.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                System.out.println(node + "-[:" + rel.getType().name() + " " + Neo4jHelper.dump((PropertyContainer)rel) + "]->" + rel.getEndNode());
            }
        }
    }

    private static String dump(PropertyContainer pc) {
        long id = pc instanceof Node ? ((Node)pc).getId() : ((Relationship)pc).getId();
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String prop : pc.getPropertyKeys()) {
                props.put(prop, pc.getProperty(prop));
            }
            return String.format("(%d) %s ", id, props);
        }
        catch (Exception e) {
            return "(" + id + ") " + e.getMessage();
        }
    }

    public static void cleanDb(GraphDatabaseService graphDatabaseService) {
        Neo4jHelper.cleanDb(graphDatabaseService, false);
    }

    public static void cleanDb(GraphDatabaseService graphDatabaseService, boolean includeReferenceNode) {
        Transaction tx = graphDatabaseService.beginTx();
        try {
            Neo4jHelper.removeNodes(graphDatabaseService, includeReferenceNode);
            Neo4jHelper.clearIndex(graphDatabaseService);
            tx.success();
        }
        catch (Throwable t) {
            tx.failure();
            throw new UncategorizedGraphStoreException("Error cleaning database ", t);
        }
        finally {
            tx.finish();
        }
    }

    private static void removeNodes(GraphDatabaseService graphDatabaseService, boolean includeReferenceNode) {
        GlobalGraphOperations globalGraphOperations = GlobalGraphOperations.at((GraphDatabaseService)graphDatabaseService);
        for (Node node : globalGraphOperations.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                try {
                    rel.delete();
                }
                catch (IllegalStateException ise) {
                    if (ise.getMessage().contains("since it has already been deleted")) continue;
                    throw ise;
                }
            }
        }
        for (Node node : globalGraphOperations.getAllNodes()) {
            if (!includeReferenceNode && graphDatabaseService.getReferenceNode().equals(node)) continue;
            try {
                node.delete();
            }
            catch (IllegalStateException ise) {
                if (ise.getMessage().contains("since it has already been deleted")) continue;
                throw ise;
            }
        }
    }

    private static void clearIndex(GraphDatabaseService gds) {
        IndexManager indexManager = gds.index();
        for (String ix : indexManager.nodeIndexNames()) {
            indexManager.forNodes(ix).delete();
        }
        for (String ix : indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(ix).delete();
        }
    }
}

