/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.ArrayList;
import java.util.Collections;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.mapping.IndexInfo;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipProperties;
import org.springframework.data.neo4j.mapping.RelationshipResult;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;

public class EntityStateHandler {
    private Neo4jMappingContext mappingContext;
    private final GraphDatabase graphDatabase;

    public EntityStateHandler(Neo4jMappingContext mappingContext, GraphDatabase graphDatabase) {
        this.mappingContext = mappingContext;
        this.graphDatabase = graphDatabase;
    }

    public <S extends PropertyContainer> void setPersistentState(Object entity, S state) {
        if (entity instanceof PropertyContainer) {
            return;
        }
        if (this.isManaged(entity)) {
            ((ManagedEntity)entity).setPersistentState(state);
            return;
        }
        Class<?> type = entity.getClass();
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(type);
        persistentEntity.setPersistentState(entity, state);
    }

    public boolean isManaged(Object entity) {
        return entity instanceof ManagedEntity;
    }

    public boolean isManaged(Class type) {
        return ManagedEntity.class.isAssignableFrom(type);
    }

    public boolean hasPersistentState(Object entity) {
        if (entity instanceof PropertyContainer) {
            return true;
        }
        if (this.isManaged(entity)) {
            return ((ManagedEntity)entity).getPersistentState() != null;
        }
        return this.getId(entity) != null;
    }

    private Number getId(Object entity) {
        Class<?> type = entity.getClass();
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(type);
        Object id = persistentEntity.getPersistentId(entity);
        if (id == null) {
            return null;
        }
        if (id instanceof Number) {
            return (Number)id;
        }
        throw new IllegalArgumentException("The id of " + persistentEntity.getEntityName() + " " + persistentEntity.getIdProperty() + " is not a number");
    }

    public <S extends PropertyContainer> S getPersistentState(Object entity) {
        return this.getPersistentState(entity, true);
    }

    public <S extends PropertyContainer> S getPersistentState(Object entity, boolean check) {
        if (entity instanceof PropertyContainer) {
            return (S)((PropertyContainer)entity);
        }
        if (this.isManaged(entity)) {
            return (S)((PropertyContainer)((ManagedEntity)entity).getPersistentState());
        }
        Number id = this.getId(entity);
        if (id == null) {
            return null;
        }
        long graphId = id.longValue();
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(entity.getClass());
        if (persistentEntity.isNodeEntity()) {
            return (S)this.graphDatabase.getNodeById(graphId);
        }
        if (persistentEntity.isRelationshipEntity()) {
            return (S)this.graphDatabase.getRelationshipById(graphId);
        }
        if (check) {
            throw new IllegalArgumentException("The entity " + persistentEntity.getEntityName() + " has to be either annotated with @NodeEntity or @RelationshipEntity");
        }
        return null;
    }

    public boolean isNodeEntity(Class<?> targetType) {
        return this.mappingContext.isNodeEntity(targetType);
    }

    public boolean isRelationshipEntity(Class targetType) {
        return this.mappingContext.isRelationshipEntity(targetType);
    }

    public <S extends PropertyContainer> S useOrCreateState(Object entity, S state, RelationshipType annotationProvidedRelationshipType) {
        if (state != null) {
            return state;
        }
        S containedState = this.getPersistentState(entity);
        if (containedState != null) {
            return containedState;
        }
        Class<?> type = entity.getClass();
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(type);
        MappingPolicy mappingPolicy = persistentEntity.getMappingPolicy();
        if (persistentEntity.isNodeEntity()) {
            if (persistentEntity.isUnique()) {
                return (S)this.createUniqueNode(persistentEntity.getUniqueProperty(), entity);
            }
            return (S)this.graphDatabase.createNode(null);
        }
        if (persistentEntity.isRelationshipEntity()) {
            return this.getOrCreateRelationship(entity, persistentEntity, annotationProvidedRelationshipType);
        }
        throw new IllegalArgumentException("The entity " + persistentEntity.getEntityName() + " has to be either annotated with @NodeEntity or @RelationshipEntity");
    }

    private Node createUniqueNode(Neo4jPersistentProperty uniqueProperty, Object entity) {
        IndexInfo indexInfo = uniqueProperty.getIndexInfo();
        Object value = uniqueProperty.getValueFromEntity(entity, MappingPolicy.MAP_FIELD_DIRECT_POLICY);
        if (value == null) {
            throw new MappingException("Error creating " + uniqueProperty.getOwner().getName() + " with " + entity + " unique property " + uniqueProperty.getName() + " has null value");
        }
        return this.graphDatabase.getOrCreateNode(indexInfo.getIndexName(), indexInfo.getIndexKey(), value, Collections.<String, Object>emptyMap());
    }

    private <S extends PropertyContainer> S getOrCreateRelationship(Object entity, Neo4jPersistentEntity<?> persistentEntity, RelationshipType annotationProvidedRelationshipType) {
        RelationshipProperties relationshipProperties = persistentEntity.getRelationshipProperties();
        Neo4jPersistentProperty startNodeProperty = relationshipProperties.getStartNodeProperty();
        Node startNode = (Node)this.getPersistentState(startNodeProperty.getValue(entity, startNodeProperty.getMappingPolicy()));
        Neo4jPersistentProperty endNodeProperty = relationshipProperties.getEndNodeProperty();
        Node endNode = (Node)this.getPersistentState(endNodeProperty.getValue(entity, endNodeProperty.getMappingPolicy()));
        RelationshipType relationshipType = this.getRelationshipType(persistentEntity, entity, annotationProvidedRelationshipType);
        if (persistentEntity.isUnique()) {
            Neo4jPersistentProperty uniqueProperty = persistentEntity.getUniqueProperty();
            IndexInfo indexInfo = uniqueProperty.getIndexInfo();
            Object value = uniqueProperty.getValueFromEntity(entity, MappingPolicy.MAP_FIELD_DIRECT_POLICY);
            if (value == null) {
                throw new MappingException("Error creating " + uniqueProperty.getOwner().getName() + " with " + entity + " unique property " + uniqueProperty.getName() + " has null value");
            }
            return (S)this.graphDatabase.getOrCreateRelationship(indexInfo.getIndexName(), indexInfo.getIndexKey(), value, startNode, endNode, relationshipType.name(), Collections.<String, Object>emptyMap());
        }
        return (S)this.graphDatabase.createRelationship(startNode, endNode, relationshipType, Collections.<String, Object>emptyMap());
    }

    private RelationshipType getRelationshipType(Neo4jPersistentEntity persistentEntity, Object entity, RelationshipType annotationProvidedRelationshipType) {
        Object value;
        RelationshipProperties relationshipProperties = persistentEntity.getRelationshipProperties();
        Neo4jPersistentProperty typeProperty = relationshipProperties.getTypeProperty();
        if (typeProperty != null && (value = typeProperty.getValue(entity, typeProperty.getMappingPolicy())) != null) {
            return value instanceof RelationshipType ? (RelationshipType)value : DynamicRelationshipType.withName((String)value.toString());
        }
        if (annotationProvidedRelationshipType != null) {
            return annotationProvidedRelationshipType;
        }
        String relationshipTypeAsString = relationshipProperties.getRelationshipType();
        if (relationshipTypeAsString == null) {
            throw new MappingException("Could not determine relationship-type for " + persistentEntity.getName());
        }
        return DynamicRelationshipType.withName((String)relationshipTypeAsString);
    }

    public RelationshipResult relateTo(Object source, Object target, String type) {
        return this.createRelationshipBetween(source, target, type, false);
    }

    public RelationshipResult createRelationshipBetween(Object source, Object target, String type, boolean allowDuplicates) {
        Relationship relationship;
        if (source == null) {
            throw new IllegalArgumentException("Source entity is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target entity is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Relationshiptype is null");
        }
        Node sourceNode = this.getPersistentState(source, Node.class);
        Node targetNode = this.getPersistentState(target, Node.class);
        if (!allowDuplicates && (relationship = this.getRelationshipBetween(sourceNode, targetNode, type)) != null) {
            return new RelationshipResult(relationship, RelationshipResult.Type.EXISTING);
        }
        if (sourceNode == null) {
            throw new IllegalArgumentException("Source Node  is null");
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Target Node is null");
        }
        relationship = sourceNode.createRelationshipTo(targetNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
        return new RelationshipResult(relationship, RelationshipResult.Type.NEW);
    }

    public <R extends PropertyContainer> R getPersistentState(Object entity, Class<R> type) {
        Object state = this.getPersistentState(entity);
        if (type == null || type.isInstance(state)) {
            return (R)state;
        }
        throw new IllegalArgumentException("Target state is not the requested " + type + " but " + state);
    }

    public RelationshipResult removeRelationshipTo(Object source, Object target, String relationshipType) {
        Relationship relationship = this.getRelationshipBetween(source, target, relationshipType);
        if (relationship != null) {
            this.graphDatabase.remove(relationship);
            return new RelationshipResult(relationship, RelationshipResult.Type.DELETED);
        }
        return null;
    }

    public Relationship getRelationshipBetween(Object source, Object target, String type) {
        if (source == null) {
            throw new IllegalArgumentException("Source entity is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target entity is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Relationshiptype is null");
        }
        Node node = (Node)this.getPersistentState(source);
        Node targetNode = (Node)this.getPersistentState(target);
        if (node == null || targetNode == null) {
            return null;
        }
        Iterable relationships = node.getRelationships((RelationshipType)DynamicRelationshipType.withName((String)type), Direction.OUTGOING);
        for (Relationship relationship : relationships) {
            if (!relationship.getEndNode().equals(targetNode)) continue;
            return relationship;
        }
        return null;
    }

    public final boolean equals(Object first, Object second) {
        if (second == first) {
            return true;
        }
        if (second == null) {
            return false;
        }
        Object firstState = this.getPersistentState(first, false);
        if (firstState == null) {
            return false;
        }
        Object secondState = this.getPersistentState(second, false);
        if (secondState == null) {
            return false;
        }
        return firstState.equals(secondState);
    }

    public final int hashCode(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null");
        }
        Object state = this.getPersistentState(entity);
        if (state == null) {
            return System.identityHashCode(entity);
        }
        return state.hashCode();
    }

    public Iterable<Relationship> getRelationshipsBetween(Object source, Object target, String type) {
        if (source == null) {
            throw new IllegalArgumentException("Source entity is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target entity is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Relationshiptype is null");
        }
        Node node = (Node)this.getPersistentState(source);
        Node targetNode = (Node)this.getPersistentState(target);
        if (node == null || targetNode == null) {
            return null;
        }
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (Relationship relationship : node.getRelationships((RelationshipType)DynamicRelationshipType.withName((String)type), Direction.OUTGOING)) {
            if (!relationship.getEndNode().equals(targetNode)) continue;
            result.add(relationship);
        }
        return result;
    }
}

