/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.neo4j.graphdb.index.Index;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;

public class IndexCreationMappingEventListener
implements ApplicationListener<MappingContextEvent<Neo4jPersistentEntity<?>, Neo4jPersistentProperty>> {
    private Neo4jTemplate template;

    public IndexCreationMappingEventListener(Neo4jTemplate template) {
        this.template = template;
    }

    public void onApplicationEvent(MappingContextEvent<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> event) {
        if (!(event.getSource() instanceof Neo4jMappingContext)) {
            return;
        }
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)event.getPersistentEntity();
        this.ensureEntityIndexes(entity);
    }

    private void ensureEntityIndexes(Neo4jPersistentEntity<?> entity) {
        final Class entityType = entity.getType();
        Index index = this.template.getIndex(entityType, null, IndexType.SIMPLE);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

            public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                if (property.isIndexed()) {
                    IndexCreationMappingEventListener.this.template.getIndex(property, entityType);
                }
            }
        });
    }
}

