/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.data.neo4j.annotation.ResultColumn;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.conversion.NoSuchColumnFoundException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class QueryResultProxy
implements InvocationHandler {
    private final Map<String, Object> map;
    private final MappingPolicy mappingPolicy;
    private final ResultConverter converter;

    public QueryResultProxy(Map<String, Object> map, MappingPolicy mappingPolicy, ResultConverter converter) {
        this.map = map;
        this.mappingPolicy = mappingPolicy;
        this.converter = converter;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        ResultColumn column = method.getAnnotation(ResultColumn.class);
        TypeInformation returnType = ClassTypeInformation.fromReturnTypeOf((Method)method);
        String columnName = column.value();
        if (!this.map.containsKey(columnName)) {
            throw new NoSuchColumnFoundException(columnName);
        }
        Object columnValue = this.map.get(columnName);
        if (columnValue == null) {
            return null;
        }
        Class iterableLikeInterface = this.implementsInterface("scala.collection.Iterable", columnValue.getClass());
        if (iterableLikeInterface != null) {
            columnValue = this.transformScalaIterableToJavaIterable(columnValue, iterableLikeInterface);
        }
        if (returnType.isCollectionLike()) {
            return new QueryResultBuilder((Iterable)columnValue, this.converter).to(returnType.getActualType().getType());
        }
        return this.converter.convert(columnValue, returnType.getType(), this.mappingPolicy);
    }

    public Object transformScalaIterableToJavaIterable(Object scalaIterable, Class iterableLikeIface) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> javaConversions = iterableLikeIface.getClassLoader().loadClass("scala.collection.JavaConversions");
        Method asJavaIterable = javaConversions.getMethod("asJavaIterable", iterableLikeIface);
        Iterable javaIterable = (Iterable)asJavaIterable.invoke(null, scalaIterable);
        return javaIterable;
    }

    private Class implementsInterface(String interfaceName, Class clazz) {
        Class iface;
        if (clazz.getCanonicalName().equals(interfaceName)) {
            return clazz;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && (iface = this.implementsInterface(interfaceName, superclass)) != null) {
            return iface;
        }
        for (Class<?> iface2 : clazz.getInterfaces()) {
            Class superIface = this.implementsInterface(interfaceName, iface2);
            if (superIface == null) continue;
            return superIface;
        }
        return null;
    }
}

