/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;
import org.springframework.util.Assert;

public class AuditingEventListener
implements ApplicationListener<BeforeSaveEvent<Object>> {
    private final IsNewAwareAuditingHandler<Object> auditingHandler;

    public AuditingEventListener(IsNewAwareAuditingHandler<Object> auditingHandler) {
        Assert.notNull(auditingHandler, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandler = auditingHandler;
    }

    public void onApplicationEvent(BeforeSaveEvent<Object> event) {
        Object entity = event.getEntity();
        this.auditingHandler.markAudited(entity);
    }
}

