/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.mapping.InvalidEntityTypeException;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.mapping.EntityAlias;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentPropertyImpl;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.util.TypeInformation;

public class Neo4jMappingContext
extends AbstractMappingContext<Neo4jPersistentEntityImpl<?>, Neo4jPersistentProperty> {
    private final Map<Class<?>, Class<?>> annotationCheckCache = new IdentityHashMap();
    private EntityAlias entityAlias = new EntityAlias();

    protected <T> Neo4jPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        Class type = typeInformation.getType();
        if (type.isAnnotationPresent(NodeEntity.class)) {
            return new Neo4jPersistentEntityImpl<T>(typeInformation);
        }
        if (type.isAnnotationPresent(RelationshipEntity.class)) {
            return new Neo4jPersistentEntityImpl<T>(typeInformation);
        }
        throw new InvalidEntityTypeException("Type " + type + " is neither a @NodeEntity nor a @RelationshipEntity");
    }

    protected Neo4jPersistentEntityImpl<?> addPersistentEntity(TypeInformation<?> typeInformation) {
        Neo4jPersistentEntityImpl entity = (Neo4jPersistentEntityImpl)super.addPersistentEntity(typeInformation);
        List<Neo4jPersistentEntity<?>> superTypeEntities = this.addSuperTypes(entity);
        entity.updateStoredType(new StoredEntityType(entity, superTypeEntities, this.entityAlias));
        return entity;
    }

    private List<Neo4jPersistentEntity<?>> addSuperTypes(Neo4jPersistentEntity<?> entity) {
        ArrayList entities = new ArrayList();
        Class type = entity.getType();
        entities.addAll(this.addPersistentEntityWithCheck(type.getSuperclass()));
        for (Class<?> anInterface : type.getInterfaces()) {
            entities.addAll(this.addPersistentEntityWithCheck(anInterface));
        }
        return entities;
    }

    private Collection<Neo4jPersistentEntity<?>> addPersistentEntityWithCheck(Class<?> type) {
        if (type != null && (this.isNodeEntityType(type) || this.isRelationshipEntityType(type))) {
            return Collections.singletonList(this.addPersistentEntity(type));
        }
        return Collections.emptyList();
    }

    private boolean isRelationshipEntityType(Class<?> type) {
        return type.isAnnotationPresent(RelationshipEntity.class);
    }

    private boolean isNodeEntityType(Class<?> type) {
        return type.isAnnotationPresent(NodeEntity.class);
    }

    public Neo4jPersistentEntity<?> getPersistentEntity(Object alias) {
        for (Neo4jPersistentEntityImpl entity : this.getPersistentEntities()) {
            if (!entity.matchesAlias(alias)) continue;
            return entity;
        }
        return this.tryToResolveAliasAsEntityClassName(alias);
    }

    private Neo4jPersistentEntity<?> tryToResolveAliasAsEntityClassName(Object alias) {
        if (alias instanceof Class) {
            try {
                return (Neo4jPersistentEntity)this.getPersistentEntity((Class)alias);
            }
            catch (MappingException me) {
                // empty catch block
            }
        }
        if (alias instanceof String && alias.toString().contains(".")) {
            try {
                return this.tryToResolveAliasAsEntityClassName(Class.forName(alias.toString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (alias instanceof StoredEntityType) {
            return ((StoredEntityType)alias).getEntity();
        }
        return null;
    }

    public StoredEntityType getStoredEntityType(Class type) {
        return ((Neo4jPersistentEntityImpl)this.getPersistentEntity(type)).getEntityType();
    }

    protected Neo4jPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, Neo4jPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new Neo4jPersistentPropertyImpl(field, descriptor, owner, simpleTypeHolder, this);
    }

    public boolean isNodeEntity(Class<?> type) {
        if (!this.annotationCheckCache.containsKey(type)) {
            this.cacheType(type);
        }
        return this.checkAnnotationType(type, NodeEntity.class);
    }

    private void cacheType(Class<?> type) {
        try {
            Neo4jPersistentEntityImpl entity = (Neo4jPersistentEntityImpl)this.getPersistentEntity(type);
            if (entity == null) {
                this.annotationCheckCache.put(type, type);
            } else if (entity.isNodeEntity()) {
                this.annotationCheckCache.put(type, NodeEntity.class);
            } else if (entity.isRelationshipEntity()) {
                this.annotationCheckCache.put(type, RelationshipEntity.class);
            } else {
                this.annotationCheckCache.put(type, type);
            }
        }
        catch (InvalidEntityTypeException me) {
            this.annotationCheckCache.put(type, type);
        }
    }

    private boolean checkAnnotationType(Class<?> type, Class<?> annotation) {
        Class<?> marker = this.annotationCheckCache.get(type);
        return marker == annotation;
    }

    public boolean isRelationshipEntity(Class<?> type) {
        if (!this.annotationCheckCache.containsKey(type)) {
            this.cacheType(type);
        }
        return this.checkAnnotationType(type, RelationshipEntity.class);
    }

    public void setPersistentState(Object entity, PropertyContainer pc) {
        Neo4jPersistentEntityImpl persistentEntity = (Neo4jPersistentEntityImpl)this.getPersistentEntity(entity.getClass());
        persistentEntity.setPersistentState(entity, pc);
    }

    public EntityAlias getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(EntityAlias entityAlias) {
        this.entityAlias = entityAlias;
    }
}

