/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.neo4j.template.GraphCallback;

public interface Neo4jOperations {
    public <T> T exec(GraphCallback<T> var1);

    public <T> GraphRepository<T> repositoryFor(Class<T> var1);

    public Node getReferenceNode();

    public Node getNode(long var1);

    public Node createNode(Map<String, Object> var1);

    public Node createNode();

    public <T> T createNodeAs(Class<T> var1, Map<String, Object> var2);

    public Relationship getRelationship(long var1);

    public Relationship createRelationshipBetween(Node var1, Node var2, String var3, Map<String, Object> var4);

    public <R> R getRelationshipBetween(Object var1, Object var2, Class<R> var3, String var4);

    public Relationship getRelationshipBetween(Object var1, Object var2, String var3);

    public void deleteRelationshipBetween(Object var1, Object var2, String var3);

    public <R> R createRelationshipBetween(Object var1, Object var2, Class<R> var3, String var4, boolean var5);

    public <T extends PropertyContainer> Index<T> getIndex(String var1, Class<?> var2);

    public <T extends PropertyContainer> Index<T> getIndex(Class<?> var1, String var2);

    public <T extends PropertyContainer> T index(String var1, T var2, String var3, Object var4);

    public <T extends PropertyContainer> Result<T> lookup(String var1, String var2, Object var3);

    public <T extends PropertyContainer> Result<T> lookup(Class<?> var1, String var2, Object var3);

    public <T extends PropertyContainer> Result<T> lookup(String var1, Object var2);

    public <T> QueryEngine<T> queryEngineFor(QueryType var1);

    public Result<Map<String, Object>> query(String var1, Map<String, Object> var2);

    public Result<Object> execute(String var1, Map<String, Object> var2);

    public Result<Path> traverse(Node var1, TraversalDescription var2);

    public Result<Path> traverse(Object var1, TraversalDescription var2);

    public <T> Result<T> convert(Iterable<T> var1);

    public <T> T convert(Object var1, Class<T> var2);

    public <T> T findOne(long var1, Class<T> var3);

    public <T> ClosableIterable<T> findAll(Class<T> var1);

    public <T> long count(Class<T> var1);

    public <T> T projectTo(Object var1, Class<T> var2);

    public <T> T save(T var1);

    public void delete(Object var1);

    public <S extends PropertyContainer> S getPersistentState(Object var1);

    public TraversalDescription traversalDescription();

    public GraphDatabase getGraphDatabase();

    public <T> T fetch(T var1);

    public <S extends PropertyContainer, T> T load(S var1, Class<T> var2);

    public MappingPolicy getMappingPolicy(Class<?> var1);

    public ResultConverter getDefaultConverter();
}

