/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.neo4j.repository.GraphEntityInformation;
import org.springframework.data.neo4j.repository.GraphMetamodelEntityInformation;
import org.springframework.data.neo4j.repository.NodeGraphRepositoryImpl;
import org.springframework.data.neo4j.repository.RelationshipGraphRepository;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class GraphRepositoryFactory
extends RepositoryFactorySupport {
    private final Neo4jTemplate template;
    private final Neo4jMappingContext mappingContext;

    public GraphRepositoryFactory(Neo4jTemplate template, Neo4jMappingContext mappingContext) {
        Assert.notNull((Object)template);
        Assert.notNull((Object)((Object)mappingContext));
        this.template = template;
        this.mappingContext = mappingContext;
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        return this.getTargetRepository(metadata, this.template);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata, Neo4jTemplate template) {
        Class type = metadata.getDomainClass();
        GraphEntityInformation entityInformation = (GraphEntityInformation)this.getEntityInformation(type);
        if (entityInformation.isNodeEntity()) {
            return new NodeGraphRepositoryImpl(type, template);
        }
        return new RelationshipGraphRepository(type, template);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        Class domainClass = repositoryMetadata.getDomainClass();
        GraphEntityInformation entityInformation = (GraphEntityInformation)this.getEntityInformation(domainClass);
        if (entityInformation.isNodeEntity()) {
            return NodeGraphRepositoryImpl.class;
        }
        if (entityInformation.isRelationshipEntity()) {
            return RelationshipGraphRepository.class;
        }
        throw new IllegalArgumentException("Invalid Domain Class " + domainClass + " neither Node- nor RelationshipEntity");
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> type) {
        return new GraphMetamodelEntityInformation(type, this.template);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new QueryLookupStrategy(){

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, NamedQueries namedQueries) {
                GraphQueryMethod queryMethod = new GraphQueryMethod(method, repositoryMetadata, namedQueries, GraphRepositoryFactory.this.mappingContext);
                return queryMethod.createQuery(GraphRepositoryFactory.this.template);
            }
        };
    }
}

