/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;

public class TransientFieldAccessorFactory
implements FieldAccessorFactory {
    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.isReallyTransient();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new TransientFieldAccessor(property);
    }

    public static class TransientFieldAccessor
    implements FieldAccessor {
        protected final Neo4jPersistentProperty property;

        public TransientFieldAccessor(Neo4jPersistentProperty property) {
            this.property = property;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            return newVal;
        }

        @Override
        public boolean isWriteable(Object entity) {
            return true;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            return null;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

