/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.NodeRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.OneToNRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class ReadOnlyOneToNRelationshipFieldAccessorFactory
extends NodeRelationshipFieldAccessorFactory {
    public ReadOnlyOneToNRelationshipFieldAccessorFactory(Neo4jTemplate template) {
        super(template);
    }

    @Override
    public boolean accept(Neo4jPersistentProperty f) {
        if (!f.isRelationship()) {
            return false;
        }
        RelationshipInfo info = f.getRelationshipInfo();
        return info.isMultiple() && info.targetsNodes() && info.isReadonly();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new ReadOnlyOneToNRelationshipFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), property.getRelationshipInfo().getTargetType().getType(), this.template, property);
    }

    public static class ReadOnlyOneToNRelationshipFieldAccessor
    extends OneToNRelationshipFieldAccessorFactory.OneToNRelationshipFieldAccessor {
        public ReadOnlyOneToNRelationshipFieldAccessor(RelationshipType type, Direction direction, Class<?> elementClass, Neo4jTemplate template, Neo4jPersistentProperty field) {
            super(type, direction, elementClass, template, field);
        }

        @Override
        public boolean isWriteable(Object entity) {
            return false;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            throw new InvalidDataAccessApiUsageException("Cannot set read-only relationship entity field.");
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

