/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.typerepresentation.AbstractIndexingTypeRepresentationStrategy;

public class IndexingNodeTypeRepresentationStrategy
extends AbstractIndexingTypeRepresentationStrategy<Node>
implements NodeTypeRepresentationStrategy {
    public static final String INDEX_NAME = "__types__";

    public IndexingNodeTypeRepresentationStrategy(GraphDatabase graphDb, IndexProvider indexProvider) {
        super(graphDb, indexProvider, INDEX_NAME, Node.class, NodeEntity.class);
    }

    @Override
    protected void addToTypesIndex(Node node, Class<?> entityClass) {
        Class<?> klass = entityClass;
        while (klass.getAnnotation(NodeEntity.class) != null) {
            String value = klass.getName();
            if (this.indexProvider != null) {
                value = this.indexProvider.createIndexValueForType(klass);
            }
            this.getTypesIndex().add((PropertyContainer)node, "className", (Object)value);
            klass = klass.getSuperclass();
        }
    }
}

