/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.lang.annotation.Annotation;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.support.index.ClosableIndexHits;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.typerepresentation.EntityTypeCache;

public abstract class AbstractIndexingTypeRepresentationStrategy<S extends PropertyContainer>
implements TypeRepresentationStrategy<S> {
    public static final String TYPE_PROPERTY_NAME = "__type__";
    public static final String INDEX_KEY = "className";
    protected String INDEX_NAME;
    protected final GraphDatabase graphDb;
    protected final EntityTypeCache typeCache;
    protected final IndexProvider indexProvider;
    private final Class<? extends PropertyContainer> clazz;
    private final Class<? extends Annotation> typeEntityClass;

    public AbstractIndexingTypeRepresentationStrategy(GraphDatabase graphDb, IndexProvider indexProvider, String indexName, Class<? extends PropertyContainer> clazz, Class<? extends Annotation> typeEntityClass) {
        this.graphDb = graphDb;
        this.indexProvider = indexProvider;
        this.typeCache = new EntityTypeCache();
        this.INDEX_NAME = indexName;
        this.clazz = clazz;
        this.typeEntityClass = typeEntityClass;
    }

    public Index<S> getTypesIndex() {
        return this.graphDb.createIndex(this.clazz, this.INDEX_NAME, IndexType.SIMPLE);
    }

    @Override
    public void postEntityCreation(S state, Class<?> type) {
        this.addToTypesIndex(state, type);
        state.setProperty(TYPE_PROPERTY_NAME, (Object)type.getName());
    }

    @Override
    public long count(Class<?> entityClass) {
        long count = 0L;
        IndexHits hits = this.getTypesIndex().get(INDEX_KEY, (Object)entityClass.getName());
        while (hits.hasNext()) {
            hits.next();
            ++count;
        }
        return count;
    }

    @Override
    public void preEntityRemoval(S state) {
        this.getTypesIndex().remove(state);
    }

    @Override
    public <U> ClosableIterable<S> findAll(Class<U> clazz) {
        return this.findAllRelBacked(clazz);
    }

    @Override
    public <U> Class<U> getJavaType(S propertyContainer) {
        if (propertyContainer == null) {
            throw new IllegalArgumentException("Relationship or Node is null");
        }
        String className = (String)propertyContainer.getProperty(TYPE_PROPERTY_NAME);
        return this.typeCache.getClassForName(className);
    }

    protected void addToTypesIndex(S relationshipOrNode, Class<?> entityClass) {
        Class<?> type = entityClass;
        while (type.getAnnotation(this.typeEntityClass) != null) {
            String value = entityClass.getName();
            if (this.indexProvider != null) {
                value = this.indexProvider.createIndexValueForType(entityClass);
            }
            this.getTypesIndex().add(relationshipOrNode, INDEX_KEY, (Object)value);
            type = type.getSuperclass();
        }
    }

    private <Object> ClosableIterable<S> findAllRelBacked(Class<Object> clazz) {
        String value = clazz.getName();
        if (this.indexProvider != null) {
            value = this.indexProvider.createIndexValueForType(clazz);
        }
        IndexHits allEntitiesOfType = this.getTypesIndex().get(INDEX_KEY, (Object)value);
        return new ClosableIndexHits(allEntitiesOfType);
    }
}

