/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import org.neo4j.graphdb.Node;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DetachedEntityState;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.node.EntityStateFactory;
import org.springframework.data.neo4j.support.node.NodeEntityState;

public class NodeEntityStateFactory
implements EntityStateFactory<Node> {
    protected Neo4jTemplate template;
    protected DelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory;
    protected Neo4jMappingContext mappingContext;

    @Override
    public EntityState<Node> getEntityState(Object entity, boolean detachable) {
        Class<?> entityType = entity.getClass();
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        NodeEntityState nodeEntityState = new NodeEntityState(null, entity, entityType, this.template, this.nodeDelegatingFieldAccessorFactory, persistentEntity);
        if (!detachable) {
            return nodeEntityState;
        }
        return new DetachedEntityState<Node>(nodeEntityState, this.template);
    }

    public void setNodeDelegatingFieldAccessorFactory(DelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory) {
        this.nodeDelegatingFieldAccessorFactory = nodeDelegatingFieldAccessorFactory;
    }

    public void setTemplate(Neo4jTemplate template) {
        this.template = template;
    }

    public Neo4jMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public void setMappingContext(Neo4jMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    @Override
    public Neo4jTemplate getTemplate() {
        return this.template;
    }
}

