/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.MapResult;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.mapping.EntityPersister;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.conversion.QueryResultProxy;
import org.springframework.data.neo4j.support.path.ConvertingEntityPath;

public class EntityResultConverter<T, R>
extends DefaultConverter<T, R> {
    private final ConversionService conversionService;
    private final EntityPersister entityPersister;

    public EntityResultConverter(ConversionService conversionService, EntityPersister entityPersister) {
        this.conversionService = conversionService;
        this.entityPersister = entityPersister;
    }

    @Override
    protected Object doConvert(Object value, Class<?> sourceType, Class targetType, MappingPolicy mappingPolicy) {
        if (EntityPath.class.isAssignableFrom(targetType)) {
            return new ConvertingEntityPath(this.entityPersister, this.toPath(value, sourceType));
        }
        if (this.entityPersister.isNodeEntity(targetType)) {
            return this.entityPersister.projectTo(this.toNode(value, sourceType), targetType, mappingPolicy);
        }
        if (this.entityPersister.isRelationshipEntity(targetType)) {
            return this.entityPersister.projectTo(this.toRelationship(value, sourceType), targetType, mappingPolicy);
        }
        Object result = super.doConvert(value, sourceType, targetType, mappingPolicy);
        if (result != null) {
            return result;
        }
        if (this.conversionService.canConvert(sourceType, targetType)) {
            return this.conversionService.convert(value, targetType);
        }
        return result;
    }

    public R extractMapResult(Object value, Class returnType, MappingPolicy mappingPolicy) {
        if (!Map.class.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("MapResult can only be extracted from Map<String,Object>.");
        }
        QueryResultProxy handler = new QueryResultProxy((Map)value, mappingPolicy, this);
        return (R)Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler);
    }

    @Override
    public R convert(Object value, Class type, MappingPolicy mappingPolicy) {
        if (type.isAnnotationPresent(MapResult.class)) {
            return this.extractMapResult(value, type, mappingPolicy);
        }
        return super.convert(value, type, mappingPolicy);
    }
}

