/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Traversal;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.query.GremlinQueryEngine;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DelegatingGraphDatabase
implements GraphDatabase {
    protected GraphDatabaseService delegate;
    private ConversionService conversionService;
    private ResultConverter resultConverter;
    private static final Log log = LogFactory.getLog(DelegatingGraphDatabase.class);

    public DelegatingGraphDatabase(GraphDatabaseService delegate) {
        this.delegate = delegate;
    }

    public DelegatingGraphDatabase(GraphDatabaseService delegate, ResultConverter resultConverter) {
        this.delegate = delegate;
        this.resultConverter = resultConverter;
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public void setResultConverter(ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    @Override
    public Node getNodeById(long id) {
        return this.delegate.getNodeById(id);
    }

    @Override
    public Node createNode(Map<String, Object> props) {
        return this.setProperties(this.delegate.createNode(), props);
    }

    private <T extends PropertyContainer> T setProperties(T primitive, Map<String, Object> properties) {
        assert (primitive != null);
        if (properties == null || properties.isEmpty()) {
            return primitive;
        }
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            if (prop.getValue() == null) {
                primitive.removeProperty(prop.getKey());
                continue;
            }
            primitive.setProperty(prop.getKey(), prop.getValue());
        }
        return primitive;
    }

    private void removeFromIndexes(Node node) {
        IndexManager indexManager = this.delegate.index();
        for (String indexName : indexManager.nodeIndexNames()) {
            indexManager.forNodes(indexName).remove((PropertyContainer)node);
        }
    }

    private void removeFromIndexes(Relationship relationship) {
        IndexManager indexManager = this.delegate.index();
        for (String indexName : indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(indexName).remove((PropertyContainer)relationship);
        }
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.delegate.getRelationshipById(id);
    }

    @Override
    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        return this.setProperties(startNode.createRelationshipTo(endNode, type), props);
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        IndexManager indexManager = this.delegate.index();
        if (indexManager.existsForNodes(indexName)) {
            return indexManager.forNodes(indexName);
        }
        if (indexManager.existsForRelationships(indexName)) {
            return indexManager.forRelationships(indexName);
        }
        throw new NoSuchIndexException(indexName);
    }

    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, IndexType indexType) {
        IndexManager indexManager = this.delegate.index();
        if (this.isNode(type)) {
            if (indexManager.existsForNodes(indexName)) {
                return this.checkAndGetExistingIndex(indexName, indexType, indexManager.forNodes(indexName));
            }
            Index index = indexManager.forNodes(indexName, this.indexConfigFor(indexType));
            return index;
        }
        if (indexManager.existsForRelationships(indexName)) {
            return this.checkAndGetExistingIndex(indexName, indexType, (Index<T>)indexManager.forRelationships(indexName));
        }
        return indexManager.forRelationships(indexName, this.indexConfigFor(indexType));
    }

    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    private <T extends PropertyContainer> Index<T> checkAndGetExistingIndex(String indexName, IndexType indexType, Index<T> index) {
        Map existingConfig = this.delegate.index().getConfiguration(index);
        Map<String, String> config = this.indexConfigFor(indexType);
        if (this.configCheck(config, existingConfig, "provider") && this.configCheck(config, existingConfig, "type")) {
            return index;
        }
        throw new IllegalArgumentException("Setup for index " + indexName + " does not match. Existing: " + existingConfig + " required " + config);
    }

    private boolean configCheck(Map<String, String> config, Map<String, String> existingConfig, String setting) {
        return ObjectUtils.nullSafeEquals((Object)config.get(setting), (Object)existingConfig.get(setting));
    }

    private Map<String, String> indexConfigFor(IndexType indexType) {
        return indexType.getConfig();
    }

    @Override
    public TraversalDescription traversalDescription() {
        return Traversal.description();
    }

    @Override
    public <T> QueryEngine<T> queryEngineFor(QueryType type) {
        return this.queryEngineFor(type, this.createResultConverter());
    }

    @Override
    public <T> QueryEngine<T> queryEngineFor(QueryType type, ResultConverter resultConverter) {
        switch (type) {
            case Cypher: {
                if (!ClassUtils.isPresent((String)"org.neo4j.cypher.javacompat.ExecutionEngine", (ClassLoader)this.getClass().getClassLoader())) {
                    return new FailingQueryEngine("Cypher");
                }
                return new CypherQueryEngine(this.delegate, resultConverter);
            }
            case Gremlin: {
                if (!ClassUtils.isPresent((String)"com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph", (ClassLoader)this.getClass().getClassLoader())) {
                    return new FailingQueryEngine("Gremlin");
                }
                return new GremlinQueryEngine(this.delegate, resultConverter);
            }
        }
        throw new IllegalArgumentException("Unknown Query Engine Type " + (Object)((Object)type));
    }

    @Override
    public boolean transactionIsRunning() {
        if (!(this.delegate instanceof AbstractGraphDatabase)) {
            return true;
        }
        try {
            TransactionManager txManager = ((AbstractGraphDatabase)this.delegate).getConfig().getTxModule().getTxManager();
            return txManager.getStatus() != 6;
        }
        catch (SystemException e) {
            log.error((Object)"Error accessing TransactionManager", (Throwable)e);
            return false;
        }
    }

    @Override
    public void remove(Node node) {
        this.removeFromIndexes(node);
        node.delete();
    }

    @Override
    public void remove(Relationship relationship) {
        this.removeFromIndexes(relationship);
        relationship.delete();
    }

    private ResultConverter createResultConverter() {
        if (this.resultConverter != null) {
            return this.resultConverter;
        }
        this.resultConverter = this.conversionService != null ? new ConversionServiceQueryResultConverter(this.conversionService) : new DefaultConverter();
        return this.resultConverter;
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public Node getReferenceNode() {
        return this.delegate.getReferenceNode();
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.delegate;
    }

    private static class FailingQueryEngine<T>
    implements QueryEngine<T> {
        private String dependency;

        private FailingQueryEngine(String dependency) {
            this.dependency = dependency;
        }

        @Override
        public Result<T> query(String statement, Map<String, Object> params) {
            throw new IllegalStateException(this.dependency + " is not available, please add it to your dependencies to execute: " + statement);
        }
    }
}

