/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.ParameterResolver;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

abstract class GraphRepositoryQuery
implements RepositoryQuery,
ParameterResolver {
    private final GraphQueryMethod queryMethod;
    private final Neo4jTemplate template;

    public GraphRepositoryQuery(GraphQueryMethod queryMethod, Neo4jTemplate template) {
        Assert.notNull((Object)((Object)queryMethod));
        Assert.notNull((Object)template);
        this.queryMethod = queryMethod;
        this.template = template;
    }

    protected Neo4jTemplate getTemplate() {
        return this.template;
    }

    @Override
    public Object resolveParameter(Object value, String parameterName, int index) {
        Node state;
        Class<?> type = value.getClass();
        if (this.template.isNodeEntity(type) && (state = (Node)this.template.getPersistentState(value)) != null) {
            return state.getId();
        }
        if (this.template.isRelationshipEntity(type) && (state = (Relationship)this.template.getPersistentState(value)) != null) {
            return state.getId();
        }
        return value;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Map<String, Object> params = this.resolveParams((ParameterAccessor)accessor);
        String queryString = this.createQueryWithPagingAndSorting((ParameterAccessor)accessor);
        return this.dispatchQuery(queryString, params, (ParameterAccessor)accessor);
    }

    protected Map<String, Object> resolveParams(ParameterAccessor accessor) {
        return this.queryMethod.resolveParams(accessor, this);
    }

    protected String createQueryWithPagingAndSorting(ParameterAccessor accessor) {
        return this.queryMethod.getQueryString();
    }

    protected Object dispatchQuery(String queryString, Map<String, Object> params, ParameterAccessor accessor) {
        GraphQueryMethod queryMethod = this.getQueryMethod();
        QueryEngine<?> queryEngine = this.getQueryEngine();
        Class<?> compoundType = queryMethod.getCompoundType();
        if (queryMethod.isPageQuery()) {
            EndResult<?> result = queryEngine.query(queryString, params).to(compoundType);
            return this.createPage(result, accessor.getPageable());
        }
        if (queryMethod.isIterableResult()) {
            EndResult<?> result = queryEngine.query(queryString, params).to(compoundType);
            if (queryMethod.isSetResult()) {
                return IteratorUtil.addToCollection(result, new LinkedHashSet());
            }
            if (queryMethod.isCollectionResult()) {
                return IteratorUtil.addToCollection(result, new ArrayList());
            }
            return result;
        }
        return queryEngine.query(queryString, params).to(queryMethod.getReturnType()).singleOrNull();
    }

    public GraphQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected Object createPage(Iterable<?> result, Pageable pageable) {
        List resultList = (List)IteratorUtil.addToCollection(result, new ArrayList());
        if (pageable == null) {
            return new PageImpl(resultList);
        }
        int currentTotal = pageable.getOffset() + pageable.getPageSize();
        return new PageImpl(resultList, pageable, (long)currentTotal);
    }

    protected abstract QueryEngine<?> getQueryEngine();
}

