/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;

class CypherGraphRepositoryQuery
extends GraphRepositoryQuery {
    private QueryEngine<Object> queryEngine;

    public CypherGraphRepositoryQuery(GraphQueryMethod queryMethod, Neo4jTemplate template) {
        super(queryMethod, template);
    }

    protected QueryEngine<Object> getQueryEngine() {
        if (this.queryEngine != null) {
            return this.queryEngine;
        }
        this.queryEngine = this.getTemplate().queryEngineFor(QueryType.Cypher);
        return this.queryEngine;
    }

    private String addPaging(String baseQuery, Pageable pageable) {
        if (pageable == null) {
            return baseQuery;
        }
        return baseQuery + " skip " + pageable.getOffset() + " limit " + pageable.getPageSize();
    }

    private String addSorting(String baseQuery, Sort sort) {
        if (sort == null) {
            return baseQuery;
        }
        String sortOrder = this.getSortOrder(sort);
        if (sortOrder.isEmpty()) {
            return baseQuery;
        }
        return baseQuery + " order by " + sortOrder;
    }

    private String getSortOrder(Sort sort) {
        String result = "";
        for (Sort.Order order : sort) {
            result = result + order.getProperty() + " " + order.getDirection();
        }
        return result;
    }

    @Override
    protected String createQueryWithPagingAndSorting(ParameterAccessor accessor) {
        Pageable pageable;
        GraphQueryMethod queryMethod = this.getQueryMethod();
        Parameters parameters = queryMethod.getParameters();
        String queryString = queryMethod.getQueryString();
        if (parameters.hasSortParameter()) {
            queryString = this.addSorting(queryString, accessor.getSort());
        }
        if (parameters.hasPageableParameter() && (pageable = accessor.getPageable()) != null) {
            queryString = this.addSorting(queryString, pageable.getSort());
            queryString = this.addPaging(queryString, pageable);
        }
        return queryString;
    }
}

