/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Collections;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.NodeRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.NodeToNodesRelationshipFieldAccessor;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class SingleRelationshipFieldAccessorFactory
extends NodeRelationshipFieldAccessorFactory {
    public SingleRelationshipFieldAccessorFactory(Neo4jTemplate template) {
        super(template);
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.isRelationship() && property.getRelationshipInfo().targetsNodes() && !property.getRelationshipInfo().isMultiple();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new SingleRelationshipFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), relationshipInfo.getTargetType().getType(), this.template, property);
    }

    public static class SingleRelationshipFieldAccessor
    extends NodeToNodesRelationshipFieldAccessor {
        public SingleRelationshipFieldAccessor(RelationshipType type, Direction direction, Class<?> clazz, Neo4jTemplate template, Neo4jPersistentProperty property) {
            super(clazz, template, direction, type, property);
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Node node = (Node)this.checkUnderlyingState(entity);
            if (newVal == null) {
                this.removeMissingRelationships(node, Collections.<Node>emptySet());
                return null;
            }
            Set<Node> target = this.createSetOfTargetNodes(Collections.singleton(newVal));
            this.removeMissingRelationships(node, target);
            this.createAddedRelationships(node, target);
            return newVal;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            this.checkUnderlyingState(entity);
            Set<Object> result = this.createEntitySetFromRelationshipEndNodes(entity, this.updateMappingPolicy(mappingPolicy));
            Object singleEntity = result.isEmpty() ? null : result.iterator().next();
            return DoReturn.doReturn(singleEntity);
        }
    }
}

