/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.fieldaccess.AbstractNodeRelationshipFieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.GraphBackedEntityIterableWrapper;
import org.springframework.data.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.mapping.RelationshipProperties;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class OneToNRelationshipEntityFieldAccessorFactory
implements FieldAccessorFactory {
    private Neo4jTemplate template;

    public OneToNRelationshipEntityFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.isRelationship() && !property.getRelationshipInfo().targetsNodes() && property.getRelationshipInfo().isMultiple();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new OneToNRelationshipEntityFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), relationshipInfo.getTargetType().getType(), this.template, property);
    }

    public static class OneToNRelationshipEntityFieldAccessor
    extends AbstractNodeRelationshipFieldAccessor<Node, Relationship> {
        private final boolean isEditableSet;

        public OneToNRelationshipEntityFieldAccessor(RelationshipType type, Direction direction, Class<?> elementClass, Neo4jTemplate template, Neo4jPersistentProperty property) {
            super(elementClass, template, direction, type, property);
            this.isEditableSet = Set.class.isAssignableFrom(this.property.getType());
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            if (!this.isEditableSet) {
                throw new InvalidDataAccessApiUsageException("Cannot set read-only relationship entity field.");
            }
            Node startNode = (Node)this.checkUnderlyingState(entity);
            if (newVal == null) {
                return null;
            }
            Map<Node, Object> targetNodes = this.createSetOfTargetNodes(newVal, startNode);
            this.removeMissingRelationships(startNode, targetNodes.keySet());
            this.persistEntities(targetNodes);
            return this.createManagedSet(entity, (Set)newVal, this.updateMappingPolicy(mappingPolicy));
        }

        private void persistEntities(Map<Node, Object> targetNodes) {
            for (Object entry : targetNodes.values()) {
                this.template.save(entry);
            }
        }

        protected Map<Node, Object> createSetOfTargetNodes(Object newVal, Node startNode) {
            if (!(newVal instanceof Set)) {
                throw new IllegalArgumentException("New value must be a Set, was: " + newVal.getClass());
            }
            HashMap<Node, Object> targetNodes = new HashMap<Node, Object>();
            for (Object entry : (Set)newVal) {
                if (!this.relatedType.isInstance(entry)) {
                    throw new IllegalArgumentException("New value elements must be " + this.relatedType);
                }
                Neo4jPersistentEntity relationshipPEntity = this.property.getRelationshipInfo().getTargetEntity();
                RelationshipProperties relationshipProperties = relationshipPEntity.getRelationshipProperties();
                Neo4jPersistentProperty endNodeProperty = relationshipProperties.getEndNodeProperty();
                Object endNodeEntity = endNodeProperty.getValue(entry, endNodeProperty.getMappingPolicy());
                Node endNode = this.getState(endNodeEntity);
                if (!endNode.equals(startNode)) {
                    targetNodes.put(endNode, entry);
                    continue;
                }
                Neo4jPersistentProperty startNodeProperty = relationshipProperties.getStartNodeProperty();
                Node otherNode = this.getState(startNodeProperty.getValue(entry, startNodeProperty.getMappingPolicy()));
                targetNodes.put(otherNode, entry);
            }
            return targetNodes;
        }

        @Override
        public boolean isWriteable(Object entity) {
            return this.isEditableSet;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            this.checkUnderlyingState(entity);
            GraphBackedEntityIterableWrapper<Relationship, ?> result = this.iterableFrom(entity);
            if (this.isEditableSet) {
                ManagedFieldAccessorSet managedSet = this.createManagedSet(entity, (Set)IteratorUtil.addToCollection(result, new HashSet()), this.updateMappingPolicy(mappingPolicy));
                return DoReturn.doReturn(managedSet);
            }
            return DoReturn.doReturn(result);
        }

        private GraphBackedEntityIterableWrapper<Relationship, ?> iterableFrom(Object entity) {
            return GraphBackedEntityIterableWrapper.create(this.getStatesFromEntity(entity), this.relatedType, this.template);
        }

        @Override
        protected Iterable<Relationship> getStatesFromEntity(Object entity) {
            Node node = this.getState(entity);
            return node.getRelationships(this.type, this.direction);
        }

        @Override
        protected Relationship obtainSingleRelationship(Node start, Node end) {
            return null;
        }

        @Override
        protected Node getState(Object entity) {
            return (Node)this.template.getPersistentState(entity);
        }
    }
}

