/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class MultiTransactionStatus
implements TransactionStatus {
    private PlatformTransactionManager mainTransactionManager;
    private Map<PlatformTransactionManager, TransactionStatus> transactionStatuses = Collections.synchronizedMap(new HashMap());
    private boolean newSynchonization;

    public MultiTransactionStatus(PlatformTransactionManager mainTransactionManager) {
        this.mainTransactionManager = mainTransactionManager;
    }

    private Map<PlatformTransactionManager, TransactionStatus> getTransactionStatuses() {
        return this.transactionStatuses;
    }

    private TransactionStatus getMainTransactionStatus() {
        return this.transactionStatuses.get(this.mainTransactionManager);
    }

    public void setNewSynchonization() {
        this.newSynchonization = true;
    }

    public boolean isNewSynchonization() {
        return this.newSynchonization;
    }

    public boolean isNewTransaction() {
        return this.getMainTransactionStatus().isNewTransaction();
    }

    public boolean hasSavepoint() {
        return this.getMainTransactionStatus().hasSavepoint();
    }

    public void setRollbackOnly() {
        for (TransactionStatus ts : this.transactionStatuses.values()) {
            ts.setRollbackOnly();
        }
    }

    public boolean isRollbackOnly() {
        return this.getMainTransactionStatus().isRollbackOnly();
    }

    public boolean isCompleted() {
        return this.getMainTransactionStatus().isCompleted();
    }

    public Object createSavepoint() throws TransactionException {
        SavePoints savePoints = new SavePoints();
        for (TransactionStatus transactionStatus : this.transactionStatuses.values()) {
            savePoints.save(transactionStatus);
        }
        return savePoints;
    }

    public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        SavePoints savePoints = (SavePoints)savepoint;
        savePoints.rollback();
    }

    public void releaseSavepoint(Object savepoint) throws TransactionException {
        ((SavePoints)savepoint).release();
    }

    public void registerTransactionManager(TransactionDefinition definition, PlatformTransactionManager transactionManager) {
        this.getTransactionStatuses().put(transactionManager, transactionManager.getTransaction(definition));
    }

    void commit(PlatformTransactionManager transactionManager) {
        TransactionStatus transactionStatus = this.getTransactionStatus(transactionManager);
        transactionManager.commit(transactionStatus);
    }

    private TransactionStatus getTransactionStatus(PlatformTransactionManager transactionManager) {
        return this.getTransactionStatuses().get(transactionManager);
    }

    void rollback(PlatformTransactionManager transactionManager) {
        transactionManager.rollback(this.getTransactionStatus(transactionManager));
    }

    public void flush() {
        for (TransactionStatus transactionStatus : this.transactionStatuses.values()) {
            transactionStatus.flush();
        }
    }

    private static class SavePoints {
        Map<TransactionStatus, Object> savepoints = new HashMap<TransactionStatus, Object>();

        private SavePoints() {
        }

        private void addSavePoint(TransactionStatus status, Object savepoint) {
            this.savepoints.put(status, savepoint);
        }

        private void save(TransactionStatus transactionStatus) {
            Object savepoint = transactionStatus.createSavepoint();
            this.addSavePoint(transactionStatus, savepoint);
        }

        public void rollback() {
            for (TransactionStatus transactionStatus : this.savepoints.keySet()) {
                transactionStatus.rollbackToSavepoint(this.savepointFor(transactionStatus));
            }
        }

        private Object savepointFor(TransactionStatus transactionStatus) {
            return this.savepoints.get(transactionStatus);
        }

        public void release() {
            for (TransactionStatus transactionStatus : this.savepoints.keySet()) {
                transactionStatus.releaseSavepoint(this.savepointFor(transactionStatus));
            }
        }
    }
}

