/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.relationship;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.fieldaccess.DefaultEntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipProperties;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.ParameterCheck;

public class RelationshipEntityState
extends DefaultEntityState<Relationship> {
    private final Neo4jTemplate template;
    private MappingPolicy mappingPolicy;

    public RelationshipEntityState(Relationship underlyingState, Object entity, Class<? extends Object> type, Neo4jTemplate template, DelegatingFieldAccessorFactory delegatingFieldAccessorFactory, Neo4jPersistentEntity<Object> persistentEntity) {
        super(underlyingState, entity, type, delegatingFieldAccessorFactory, persistentEntity);
        this.template = template;
        this.mappingPolicy = persistentEntity.getMappingPolicy();
    }

    @Override
    public void createAndAssignState() {
        Object state = this.template.getPersistentState(this.entity);
        if (state != null) {
            return;
        }
        try {
            Object id = this.getIdFromEntity();
            if (id instanceof Number) {
                Relationship relationship = this.template.getRelationship(((Number)id).longValue());
                this.setPersistentState(relationship);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Entity reattached " + this.entity.getClass() + "; used Relationship [" + state + "];"));
                }
                return;
            }
            Relationship relationship = this.createRelationshipFromEntity();
            this.setPersistentState(relationship);
            if (log.isInfoEnabled()) {
                log.info((Object)("User-defined constructor called on class " + this.entity.getClass() + "; created Relationship [" + this.getPersistentState() + "]; Updating metamodel"));
            }
            this.template.postEntityCreation(relationship, this.type);
        }
        catch (NotInTransactionException e) {
            throw new InvalidDataAccessResourceUsageException("Not in a Neo4j transaction.", (Throwable)e);
        }
    }

    private Relationship createRelationshipFromEntity() {
        RelationshipProperties relationshipProperties = this.getPersistentEntity().getRelationshipProperties();
        Node startNode = (Node)this.template.getPersistentState(relationshipProperties.getStartNodeProperty().getValue(this.entity, this.mappingPolicy));
        Node endNode = (Node)this.template.getPersistentState(relationshipProperties.getEndNodeProperty().getValue(this.entity, this.mappingPolicy));
        String type = this.getRelationshipTypeFromEntity(this.getPersistentEntity());
        ParameterCheck.notNull((Object)startNode, "start node property", (Object)endNode, "end node property", (Object)type, "relationship type property from field or annotation");
        return this.template.createRelationshipBetween(startNode, endNode, type, null);
    }

    private String getRelationshipTypeFromEntity(Neo4jPersistentEntity<?> persistentEntity) {
        Object value;
        RelationshipProperties relationshipProperties = persistentEntity.getRelationshipProperties();
        Neo4jPersistentProperty typeProperty = relationshipProperties.getTypeProperty();
        Object object = value = typeProperty != null ? typeProperty.getValue(this.entity, this.mappingPolicy) : null;
        if (value == null) {
            return relationshipProperties.getRelationshipType();
        }
        if (value instanceof RelationshipType) {
            return ((RelationshipType)value).name();
        }
        return (String)value;
    }

    @Override
    public Object persist() {
        if (this.getPersistentState() == null) {
            this.createAndAssignState();
        }
        return this.entity;
    }
}

