/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.core.UncategorizedGraphStoreException;
import org.springframework.data.neo4j.mapping.EntityPersister;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipResult;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.NodeGraphRepositoryImpl;
import org.springframework.data.neo4j.repository.RelationshipGraphRepository;
import org.springframework.data.neo4j.support.MappingInfrastructure;
import org.springframework.data.neo4j.support.Neo4jExceptionTranslator;
import org.springframework.data.neo4j.support.ParameterCheck;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.EntityCreatingClosableIterable;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityPersister;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class Neo4jTemplate
implements Neo4jOperations,
EntityPersister {
    private static final Log log = LogFactory.getLog(Neo4jTemplate.class);
    private MappingInfrastructure infrastructure = new MappingInfrastructure();
    private final Neo4jExceptionTranslator exceptionTranslator = new Neo4jExceptionTranslator();

    public Neo4jTemplate() {
        this.infrastructure = new MappingInfrastructure();
    }

    public Neo4jTemplate(GraphDatabase graphDatabase, PlatformTransactionManager transactionManager) {
        ParameterCheck.notNull((Object)graphDatabase, "graphDatabase");
        this.infrastructure = new MappingInfrastructure(graphDatabase, transactionManager);
    }

    public Neo4jTemplate(GraphDatabase graphDatabase) {
        ParameterCheck.notNull((Object)graphDatabase, "graphDatabase");
        this.infrastructure = new MappingInfrastructure(graphDatabase, null);
    }

    public Neo4jTemplate(MappingInfrastructure infrastructure) {
        this.infrastructure = infrastructure;
    }

    @Override
    public <T> GraphRepository<T> repositoryFor(Class<T> clazz) {
        ParameterCheck.notNull(clazz, "entity type");
        if (this.isNodeEntity(clazz)) {
            return new NodeGraphRepositoryImpl<T>(clazz, this);
        }
        if (this.isRelationshipEntity(clazz)) {
            return new RelationshipGraphRepository<T>(clazz, this);
        }
        throw new IllegalArgumentException("Can't create graph repository for non graph entity of type " + clazz);
    }

    public <S extends PropertyContainer, T> Index<S> getIndex(Class<T> type) {
        ParameterCheck.notNull(type, "entity type");
        return this.getIndexProvider().getIndex(type, null);
    }

    public <S extends PropertyContainer> Index<S> getIndex(String name) {
        ParameterCheck.notNull((Object)name, "index name");
        return this.getIndexProvider().getIndex(null, name);
    }

    public <S extends PropertyContainer, T> Index<S> getIndex(Class<T> type, String indexName, IndexType indexType) {
        return this.getIndexProvider().getIndex(type, indexName, indexType);
    }

    public boolean transactionIsRunning() {
        return this.infrastructure.getGraphDatabase().transactionIsRunning();
    }

    @Override
    public <T> T findOne(long id, Class<T> entityClass) {
        Neo4jPersistentEntityImpl<?> persistentEntity = this.getPersistentEntity(entityClass);
        if (persistentEntity.isNodeEntity()) {
            Node node = this.getNode(id);
            if (node == null) {
                return null;
            }
            return this.infrastructure.getEntityPersister().createEntityFromState(node, entityClass, persistentEntity.getMappingPolicy());
        }
        if (persistentEntity.isRelationshipEntity()) {
            Relationship relationship = this.getRelationship(id);
            if (relationship == null) {
                return null;
            }
            return this.infrastructure.getEntityPersister().createEntityFromState(relationship, entityClass, persistentEntity.getMappingPolicy());
        }
        throw new IllegalArgumentException("provided entity type is not annotated with @NodeEntiy nor @RelationshipEntity");
    }

    @Override
    public <T> ClosableIterable<T> findAll(Class<T> entityClass) {
        ParameterCheck.notNull(entityClass, "entity type");
        ClosableIterable<PropertyContainer> all = this.infrastructure.getTypeRepresentationStrategies().findAll(entityClass);
        return new EntityCreatingClosableIterable<T>(all, entityClass, this.infrastructure.getEntityPersister());
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        ParameterCheck.notNull(entityClass, "entity type");
        return this.infrastructure.getTypeRepresentationStrategies().count(entityClass);
    }

    @Override
    public <S extends PropertyContainer, T> T createEntityFromStoredType(S state) {
        ParameterCheck.notNull(state, "node or relationship");
        return this.infrastructure.getEntityPersister().createEntityFromStoredType(state);
    }

    @Override
    public <S extends PropertyContainer, T> T createEntityFromStoredType(S state, MappingPolicy mappingPolicy) {
        ParameterCheck.notNull(state, "node or relationship");
        return this.infrastructure.getEntityPersister().createEntityFromStoredType(state, mappingPolicy);
    }

    @Override
    public <S extends PropertyContainer, T> T createEntityFromState(S state, Class<T> type, MappingPolicy mappingPolicy) {
        ParameterCheck.notNull(state, "node or relationship", type, "entity class");
        return this.infrastructure.getEntityPersister().createEntityFromState(state, type, mappingPolicy);
    }

    @Override
    public <S extends PropertyContainer, T> T load(S state, Class<T> type) {
        ParameterCheck.notNull(state, "node or relationship", type, "entity class");
        return this.infrastructure.getEntityPersister().createEntityFromState(state, type, this.getMappingPolicy(type));
    }

    @Override
    public <T> T projectTo(Object entity, Class<T> targetType) {
        ParameterCheck.notNull(entity, "entity", targetType, "new entity class");
        return this.infrastructure.getEntityPersister().projectTo(entity, targetType);
    }

    @Override
    public <T> T projectTo(Object entity, Class<T> targetType, MappingPolicy mappingPolicy) {
        ParameterCheck.notNull(entity, "entity", targetType, "new entity class");
        return this.infrastructure.getEntityPersister().projectTo(entity, targetType, mappingPolicy);
    }

    @Override
    public <S extends PropertyContainer> S getPersistentState(Object entity) {
        ParameterCheck.notNull(entity, "entity");
        return this.infrastructure.getEntityPersister().getPersistentState(entity);
    }

    public <S extends PropertyContainer, T> T setPersistentState(T entity, S state) {
        ParameterCheck.notNull(entity, "entity", state, "node or relationship");
        this.infrastructure.getEntityPersister().setPersistentState(entity, state);
        return entity;
    }

    @Deprecated
    public <S extends PropertyContainer, T> void postEntityCreation(S node, Class<T> entityClass) {
        this.infrastructure.getTypeRepresentationStrategies().postEntityCreation(node, entityClass);
    }

    @Override
    public void delete(Object entity) {
        ParameterCheck.notNull(entity, "entity");
        this.infrastructure.getEntityRemover().remove(entity);
    }

    @Override
    public Node createNode() {
        return this.infrastructure.getGraphDatabase().createNode(null);
    }

    @Override
    public Node createNode(Map<String, Object> properties) {
        return this.infrastructure.getGraphDatabase().createNode(properties);
    }

    @Override
    public <T> T createNodeAs(Class<T> target, Map<String, Object> properties) {
        Node node = this.createNode(properties);
        if (this.isNodeEntity(target)) {
            this.infrastructure.getTypeRepresentationStrategies().postEntityCreation((PropertyContainer)node, target);
        }
        return this.convert(node, target);
    }

    private <T> Node createNode(Map<String, Object> properties, Class<T> target, TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy) {
        Node node = this.createNode(properties);
        if (nodeTypeRepresentationStrategy != null) {
            nodeTypeRepresentationStrategy.postEntityCreation(node, target);
        }
        return node;
    }

    public Transaction beginTx() {
        return this.infrastructure.getGraphDatabaseService().beginTx();
    }

    @PostConstruct
    public void postConstruct() {
        this.infrastructure.postConstruct();
    }

    @Override
    public boolean isNodeEntity(Class<?> targetType) {
        return this.infrastructure.getMappingContext().isNodeEntity(targetType);
    }

    @Override
    public boolean isRelationshipEntity(Class<?> targetType) {
        return this.infrastructure.getMappingContext().isRelationshipEntity(targetType);
    }

    @Override
    public <T> T save(T entity) {
        return (T)this.infrastructure.getEntityPersister().persist(entity, this.getMappingPolicy(entity));
    }

    public boolean isManaged(Object entity) {
        return this.infrastructure.getEntityStateHandler().isManaged(entity);
    }

    public Object query(String statement, Map<String, Object> params, TypeInformation<?> typeInformation) {
        TypeInformation actualType = typeInformation.getActualType();
        Class targetType = actualType.getType();
        Result result = this.queryEngineFor(QueryType.Cypher).query(statement, params);
        Class containerType = typeInformation.getType();
        if (EndResult.class.isAssignableFrom(containerType)) {
            return result;
        }
        if (actualType.isMap()) {
            return result;
        }
        if (typeInformation.isCollectionLike()) {
            return result.to(targetType).as(containerType);
        }
        return result.to(targetType).single();
    }

    @Override
    public <R> R getRelationshipBetween(Object start, Object end, Class<R> relationshipEntityClass, String relationshipType) {
        ParameterCheck.notNull(start, "start", end, "end", relationshipEntityClass, "relationshipEntityClass", relationshipType, "relationshipType");
        Relationship relationship = this.infrastructure.getEntityStateHandler().getRelationshipBetween(start, end, relationshipType);
        if (relationship == null) {
            return null;
        }
        if (Relationship.class.isAssignableFrom(relationshipEntityClass)) {
            return (R)relationship;
        }
        Neo4jPersistentEntityImpl<?> persistentEntity = this.getPersistentEntity(relationshipEntityClass);
        return this.infrastructure.getEntityPersister().createEntityFromState(relationship, relationshipEntityClass, persistentEntity.getMappingPolicy());
    }

    @Override
    public Relationship getRelationshipBetween(Object start, Object end, String relationshipType) {
        ParameterCheck.notNull(start, "start", end, "end", (Object)relationshipType, "relationshipType");
        return this.infrastructure.getEntityStateHandler().getRelationshipBetween(start, end, relationshipType);
    }

    @Override
    public void deleteRelationshipBetween(Object start, Object end, String type) {
        ParameterCheck.notNull(start, "start", end, "end", (Object)type, "relationshipType");
        this.infrastructure.getEntityRemover().removeRelationshipBetween(start, end, type);
    }

    @Override
    public <R> R createRelationshipBetween(Object start, Object end, Class<R> relationshipEntityClass, String relationshipType, boolean allowDuplicates) {
        ParameterCheck.notNull(start, "start", end, "end", relationshipEntityClass, "relationshipEntityClass", relationshipType, "relationshipType");
        RelationshipResult result = this.infrastructure.getEntityStateHandler().createRelationshipBetween(start, end, relationshipType, allowDuplicates);
        if (result.type == RelationshipResult.Type.NEW) {
            this.postEntityCreation(result.relationship, relationshipEntityClass);
        }
        return this.createEntityFromState(result.relationship, relationshipEntityClass, this.getMappingPolicy(relationshipEntityClass));
    }

    @Override
    public Relationship createRelationshipBetween(final Node startNode, final Node endNode, final String relationshipType, final Map<String, Object> properties) {
        ParameterCheck.notNull((Object)startNode, "startNode", (Object)endNode, "endNode", (Object)relationshipType, "relationshipType");
        return this.exec(new GraphCallback<Relationship>(){

            @Override
            public Relationship doWithGraph(GraphDatabase graph) throws Exception {
                return graph.createRelationship(startNode, endNode, (RelationshipType)DynamicRelationshipType.withName((String)relationshipType), properties);
            }
        });
    }

    public DataAccessException translateExceptionIfPossible(Exception ex) {
        if (ex instanceof RuntimeException) {
            return this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)ex);
        }
        return new UncategorizedGraphStoreException("Error executing callback", ex);
    }

    private <T> T doExecute(GraphCallback<T> callback) {
        ParameterCheck.notNull(callback, "callback");
        try {
            return callback.doWithGraph(this.infrastructure.getGraphDatabase());
        }
        catch (Exception e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T exec(final GraphCallback<T> callback) {
        if (this.infrastructure.getTransactionManager() == null) {
            return this.doExecute(callback);
        }
        TransactionTemplate template = new TransactionTemplate(this.infrastructure.getTransactionManager());
        return (T)template.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                return Neo4jTemplate.this.doExecute(callback);
            }
        });
    }

    @Override
    public Node getReferenceNode() {
        try {
            return this.infrastructure.getGraphDatabase().getReferenceNode();
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Node getNode(long id) {
        if (id < 0L) {
            throw new InvalidDataAccessApiUsageException("id is negative");
        }
        try {
            return this.infrastructure.getGraphDatabase().getNodeById(id);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Relationship getRelationship(long id) {
        if (id < 0L) {
            throw new InvalidDataAccessApiUsageException("id is negative");
        }
        try {
            return this.infrastructure.getGraphDatabase().getRelationshipById(id);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> T index(final String indexName, final T element, final String field, final Object value) {
        ParameterCheck.notNull(element, "element", field, "field", value, "value", indexName, "indexName");
        this.exec(new GraphCallback.WithoutResult(){

            @Override
            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                if (element instanceof Relationship) {
                    Index<Relationship> relationshipIndex = Neo4jTemplate.this.infrastructure.getGraphDatabase().createIndex(Relationship.class, indexName, IndexType.SIMPLE);
                    relationshipIndex.add((PropertyContainer)((Relationship)element), field, value);
                } else if (element instanceof Node) {
                    Neo4jTemplate.this.infrastructure.getIndexProvider().createIndex(Node.class, indexName, IndexType.SIMPLE).add((PropertyContainer)((Node)element), field, value);
                } else {
                    throw new IllegalArgumentException("Provided element is neither node nor relationship " + element);
                }
            }
        });
        return element;
    }

    @Override
    public <T> T fetch(T value) {
        if (value == null) {
            return null;
        }
        Class<?> targetType = value.getClass();
        TypeInformation targetTypeInformation = ClassTypeInformation.from(targetType);
        Neo4jEntityPersister entityPersister = this.infrastructure.getEntityPersister();
        if (targetTypeInformation.isCollectionLike()) {
            Iterable collection = (Iterable)value;
            for (Object entry : collection) {
                this.fetch(entry);
            }
            return value;
        }
        Object state = this.getPersistentState(value);
        if (state != null) {
            return entityPersister.loadEntity(value, (Node)state, MappingPolicy.LOAD_POLICY, this.getPersistentEntity(targetType));
        }
        throw new MappingException("No state information available in " + value);
    }

    @Override
    public MappingPolicy getMappingPolicy(Class<?> targetType) {
        return this.getPersistentEntity(targetType).getMappingPolicy();
    }

    @Override
    public <T> Result<T> convert(Iterable<T> iterable) {
        return new QueryResultBuilder<T>(iterable, this.getDefaultConverter());
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        return this.getDefaultConverter().convert(value, type);
    }

    @Override
    public ResultConverter getDefaultConverter() {
        return this.infrastructure.getResultConverter();
    }

    @Override
    public <T> QueryEngine<T> queryEngineFor(QueryType type) {
        return this.infrastructure.getGraphDatabase().queryEngineFor(type, this.getDefaultConverter());
    }

    @Override
    public Result<Map<String, Object>> query(String statement, Map<String, Object> params) {
        ParameterCheck.notNull((Object)statement, "statement");
        QueryEngine queryEngine = this.queryEngineFor(QueryType.Cypher);
        return queryEngine.query(statement, params);
    }

    @Override
    public Result<Object> execute(String statement, Map<String, Object> params) {
        ParameterCheck.notNull((Object)statement, "statement");
        return this.queryEngineFor(QueryType.Gremlin).query(statement, params);
    }

    @Override
    public Result<Path> traverse(Object start, TraversalDescription traversal) {
        return this.traverse((Node)this.getPersistentState(start), traversal);
    }

    public <T> Iterable<T> traverse(Object entity, Class<?> targetType, TraversalDescription traversalDescription) {
        ParameterCheck.notNull(entity, "entity", targetType, "target type", (Object)traversalDescription, "traversal description");
        return this.traverse(entity, traversalDescription).to(targetType);
    }

    @Override
    public Result<Path> traverse(Node startNode, TraversalDescription traversal) {
        ParameterCheck.notNull((Object)startNode, "start node", (Object)traversal, "traversal");
        try {
            return this.convert((Iterable)traversal.traverse(startNode));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> Result<T> lookup(String indexName, String field, Object value) {
        ParameterCheck.notNull((Object)field, "field", value, "value", (Object)indexName, "index name");
        try {
            Index<T> index = this.getIndex(indexName, null);
            return this.convert((Iterable<T>)index.get(field, value));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> Result<T> lookup(Class<?> indexedType, String propertyName, Object value) {
        ParameterCheck.notNull((Object)propertyName, "property name", indexedType, "indexedType", value, "query value");
        try {
            Index<T> index = this.getIndex(indexedType, propertyName);
            return this.convert((Iterable<T>)index.query(propertyName, value));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName, Class<?> indexedType) {
        return this.getIndexProvider().getIndex(indexedType, indexName);
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(Class<?> indexedType, String propertyName) {
        Neo4jPersistentEntityImpl<?> persistentEntity = this.getPersistentEntity(indexedType);
        Neo4jPersistentProperty property = (Neo4jPersistentProperty)persistentEntity.getPersistentProperty(propertyName);
        if (property == null) {
            return this.getIndexProvider().getIndex(indexedType, null);
        }
        return this.getIndexProvider().getIndex(property, indexedType);
    }

    private IndexProvider getIndexProvider() {
        return this.infrastructure.getIndexProvider();
    }

    private Neo4jPersistentEntityImpl<?> getPersistentEntity(Class<?> type) {
        return (Neo4jPersistentEntityImpl)this.infrastructure.getMappingContext().getPersistentEntity(type);
    }

    @Override
    public <T extends PropertyContainer> Result<T> lookup(String indexName, Object query) {
        ParameterCheck.notNull(query, "valueOrQueryObject", (Object)indexName, "indexName");
        try {
            Index<T> index = this.getIndex(indexName, null);
            return this.convert((Iterable<T>)index.query(query));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public TraversalDescription traversalDescription() {
        return this.infrastructure.getGraphDatabase().traversalDescription();
    }

    public EntityStateHandler getEntityStateHandler() {
        return this.infrastructure.getEntityStateHandler();
    }

    public ConversionService getConversionService() {
        return this.infrastructure.getConversionService();
    }

    public Validator getValidator() {
        return this.infrastructure.getValidator();
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.infrastructure.getGraphDatabaseService();
    }

    public void setInfrastructure(MappingInfrastructure infrastructure) {
        this.infrastructure = infrastructure;
    }

    public MappingInfrastructure getInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public GraphDatabase getGraphDatabase() {
        return this.infrastructure.getGraphDatabase();
    }

    public String getIndexKey(Neo4jPersistentProperty property) {
        return property.getIndexKey();
    }

    public <S extends PropertyContainer> Index<S> getIndex(Neo4jPersistentProperty property, Class<?> instanceType) {
        return this.getIndexProvider().getIndex(property, instanceType);
    }

    public MappingPolicy getMappingPolicy(Object entity) {
        ParameterCheck.notNull(entity, "entity");
        return this.getMappingPolicy(entity.getClass());
    }
}

