/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryProviders;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.util.TypeInformation;

public abstract class DelegatingFieldAccessorFactory
implements FieldAccessorFactory {
    private static final Log log = LogFactory.getLog(DelegatingFieldAccessorFactory.class);
    protected final Neo4jTemplate template;
    final Collection<FieldAccessorFactory> fieldAccessorFactories = new ArrayList<FieldAccessorFactory>();
    final Collection<FieldAccessorListenerFactory> fieldAccessorListenerFactories = new ArrayList<FieldAccessorListenerFactory>();
    private final Map<TypeInformation<?>, FieldAccessorFactoryProviders> accessorFactoryProviderCache = new HashMap();

    protected abstract Collection<FieldAccessorListenerFactory> createListenerFactories();

    protected abstract Collection<? extends FieldAccessorFactory> createAccessorFactories();

    public DelegatingFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
        this.fieldAccessorFactories.addAll(this.createAccessorFactories());
        this.fieldAccessorListenerFactories.addAll(this.createListenerFactories());
    }

    public Neo4jTemplate getTemplate() {
        return this.template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty f) {
        return true;
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        FieldAccessorFactory factory = this.factoryForField(property);
        return factory != null ? factory.forField(property) : null;
    }

    private <E> FieldAccessorFactory factoryForField(Neo4jPersistentProperty property) {
        if (property.isSyntheticField()) {
            return null;
        }
        for (FieldAccessorFactory fieldAccessorFactory : this.fieldAccessorFactories) {
            if (!fieldAccessorFactory.accept(property)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Factory " + fieldAccessorFactory + " used for field: " + property));
            }
            return fieldAccessorFactory;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No FieldAccessor configured for field: " + property));
        }
        return null;
    }

    public List<FieldAccessListener> listenersFor(Neo4jPersistentProperty property) {
        ArrayList<FieldAccessListener> result = new ArrayList<FieldAccessListener>();
        List<FieldAccessorListenerFactory> fieldAccessListenerFactories = this.getFieldAccessListenerFactories(property);
        for (FieldAccessorListenerFactory fieldAccessorListenerFactory : fieldAccessListenerFactories) {
            FieldAccessListener listener = fieldAccessorListenerFactory.forField(property);
            result.add(listener);
        }
        return result;
    }

    private <E> List<FieldAccessorListenerFactory> getFieldAccessListenerFactories(Neo4jPersistentProperty property) {
        ArrayList<FieldAccessorListenerFactory> result = new ArrayList<FieldAccessorListenerFactory>();
        for (FieldAccessorListenerFactory fieldAccessorListenerFactory : this.fieldAccessorListenerFactories) {
            if (!fieldAccessorListenerFactory.accept(property)) continue;
            result.add(fieldAccessorListenerFactory);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FieldAccessorFactoryProviders<T> accessorFactoriesFor(Neo4jPersistentEntity<?> type) {
        DelegatingFieldAccessorFactory delegatingFieldAccessorFactory = this;
        synchronized (delegatingFieldAccessorFactory) {
            TypeInformation typeInformation = type.getTypeInformation();
            FieldAccessorFactoryProviders fieldAccessorFactoryProviders = this.accessorFactoryProviderCache.get(typeInformation);
            if (fieldAccessorFactoryProviders != null) {
                return fieldAccessorFactoryProviders;
            }
            final FieldAccessorFactoryProviders newFieldAccessorFactories = new FieldAccessorFactoryProviders(typeInformation, this.template);
            type.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

                public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                    FieldAccessorFactory factory = DelegatingFieldAccessorFactory.this.factoryForField(property);
                    List listenerFactories = DelegatingFieldAccessorFactory.this.getFieldAccessListenerFactories(property);
                    newFieldAccessorFactories.add(property, factory, listenerFactories);
                }
            });
            type.doWithAssociations((AssociationHandler)new AssociationHandler<Neo4jPersistentProperty>(){

                public void doWithAssociation(Association<Neo4jPersistentProperty> association) {
                    Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
                    FieldAccessorFactory factory = DelegatingFieldAccessorFactory.this.factoryForField(property);
                    List listenerFactories = DelegatingFieldAccessorFactory.this.getFieldAccessListenerFactories(property);
                    newFieldAccessorFactories.add(property, factory, listenerFactories);
                }
            });
            this.accessorFactoryProviderCache.put(typeInformation, newFieldAccessorFactories);
            return newFieldAccessorFactories;
        }
    }
}

