/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Converter {
    private final Map<String, Method> valueOfs = new HashMap<String, Method>();

    public Object convert(String typeName, String value) {
        if (value == null) {
            return null;
        }
        if (typeName == null) {
            throw new IllegalArgumentException("TypeName must not be null");
        }
        try {
            Method valueOf = this.valueOfs.get(typeName);
            if (valueOf == null) {
                Class<?> type = Class.forName(typeName.contains(".") ? typeName : "java.lang." + typeName);
                valueOf = type.getMethod("valueOf", String.class);
                this.valueOfs.put(typeName, valueOf);
            }
            return valueOf.invoke(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error converting value %s from String to type %s", value, typeName), e);
        }
    }
}

